<?php

namespace App\Traits;

use Illuminate\Http\JsonResponse;
use DB;

trait Documentable
{
    protected function existe_documento($rut_empresa,$tipo,$folio)
    {
        if(is_null($rut_empresa) or is_null($tipo) or is_null($folio)) {
            return "Datos requeridos";
        }
        $datos = DB::table('libro_ventas')
            ->select('n_doc as folio')
            ->where('rut', '=', $rut_empresa)
            ->where('typo_doc', '=', $tipo)
            ->where('n_doc', '=', $folio)
            ->first();

        return $datos;
    }

    protected function documentoInvalido()
    {
        return new JsonResponse(['mensaje' => 'Documento No existe'], 404);
    }

}

