<?php

namespace App\Models;

use DB;
//use App\Models\Bodega;
use App\Models\Cliente;
use App\Models\FormaPago;
use App\Models\AreaNegocio;
use App\Models\Producto;
use App\Traits\Foliable;
use App\Traits\Abstrahere;

class SolicitudCompra {
    use Foliable;
    use Abstrahere;

    public function __construct(
            $id_empresa,
            $rut_empresa,
            $rut_usuario,
            $fecha,
            $generica,
            $fecha_entrega,
            $status,
            $descripcion_corta,
            $solicitado,
            $prioridad,
            array $detalles
        )
    {
        $this->id_empresa = $id_empresa;
        $this->rut_empresa = $rut_empresa;
        $this->rut_usuario = $rut_usuario;
        $this->folio = 0;
        $this->fecha = $fecha;
        $this->generica = $generica;
        $this->fecha_entrega = $fecha_entrega;
        $this->status = $status;
        $this->descripcion_corta = $descripcion_corta;
        $this->solicitado = $solicitado;
        $this->centro_beneficio = '';
        $this->centro_costo = '';
        $this->prioridad = $prioridad;
        $this->nota = '';
        $this->detalles = $detalles;
    }

    protected function fallo($mensaje, $rollback = true, $registra_folio = true)
    {
        if($registra_folio){
            $this->registraFolioSinOcupar($this->rut_empresa, $this->tipo_documento, $this->folio);
        }
        if($rollback){
            $this->rollback();
        }
        return ['mensaje' => $mensaje];
    }

    public function ingresarSolicitudCompra()
    {

        $this->folio = $this->obtenFolioSolicitudCompra();
        if(is_null($this->folio)) {
            return $this->fallo('No se pudo obtener folio.', false, true);
        }




        /*$datos_xml = [
            'TipoDTE' => $this->tipo_documento,
            'Folio' => $this->folio,
            'RUTEmisor' => trim(strtoupper($this->rut_empresa)),
            'RUTEmisor' => trim(strtoupper($this->rut_empresa)),
            'RznSoc' => $this->emisor->razon,
			'GiroEmis' => $this->emisor->giro1,
			'Telefono' => $this->emisor->telefono,
			'Acteco' => $this->emisor->codigo1,
			'DirOrigen' => $this->emisor->direccion,
			'CmnaOrigen' => $this->emisor->comuna,
			'CiudadOrigen' => $this->emisor->ciudad,

            'RUTRecep' => trim(strtoupper($this->receptor->RUT_CLIENTEPROVEEDOR)),
            'RznSocRecep' => $this->receptor->RZ_CLIENTEPROVEEDOR,
            'GiroRecep' => $this->receptor->GIRO_CLIENTEPROVEEDOR,
            'DirRecep' => $this->receptor->DIRECCION_DIRECCION,
            'CmnaRecep' => $this->receptor->ID_COMUNA,
            'CiudadRecep' => $this->receptor->ID_CIUDAD,



            'neto' => round(($this->montos_totales['neto']), 0, PHP_ROUND_HALF_UP),
            'tasaIVA' => round((19), 0, PHP_ROUND_HALF_UP),
            'iva' => round(($this->montos_totales['iva']), 0, PHP_ROUND_HALF_UP),
            'total' => round(($this->montos_totales['total']), 0, PHP_ROUND_HALF_UP),
            'exento' => round(($this->montos_totales['exento']), 0, PHP_ROUND_HALF_UP),
            'NO_facturable' => round(($this->monto_no_facturable), 0, PHP_ROUND_HALF_UP),
            'MntTotal' => round(($this->montos_totales['total']), 0, PHP_ROUND_HALF_UP),
            'Detalles' => [],
        ];

*/


        $id_ingreso_solicitud = $this->ingresoSolicitud();
        if(!$id_ingreso_solicitud){
            return $this->fallo('Excepción al ingresar datos solicitud compra.');
        }


        //dd("stop ".$id_ingreso_solicitud);

        $totalDetalle = $totalDetalleExento = 0;
        foreach($this->detalles as $detalle){

            /*$bodega = Bodega::obtenBodega($detalle['Bodega'], $this->rut_empresa);
            if(is_null($bodega)){
                return $this->fallo('Bodega '.$detalle['Bodega'].' invalida.');
            }*/

            /*$producto = Producto::obtenProducto($detalle['Codigo'], $this->rut_empresa);
            if(is_null($producto)){
                return $this->fallo('Producto '.$detalle['Codigo'].' invalido.');
            }

            $detalle['Precio'] = !isset($detalle['Precio']) ? $producto->VALOR_PRODUCTO : $detalle['Precio'];*/

            /*if($detalle['Afecto']){
                $exento = 0;
                $neto = round(($detalle['Precio']), 0, PHP_ROUND_HALF_UP);
                $total = round(($detalle['Cantidad'] * $neto - $detalle['Descuento']), 0, PHP_ROUND_HALF_UP);
                $id_usuario = '';

                $totalDetalle += $detalle['Cantidad'] * $neto;

            } else {
                $exento = round(($detalle['Precio']), 0, PHP_ROUND_HALF_UP);
                $neto = 0;
                $total = round((($detalle['Cantidad'] * $exento) - $detalle['Descuento']), 0, PHP_ROUND_HALF_UP);
                $id_usuairo = 'x';

                $totalDetalleExento += $detalle['Cantidad'] * $exento;

            }*/

            /*$datos_xml['Detalles'][] = [
                'VlrCodigo' => $producto->CODIGO_PRODUCTO,
                'NmbItem' => $producto->DESCRIPCION_PRODUCTO,
                'QtyItem' => $detalle['Cantidad'],
                'UnmdItem' => $producto->NOMBRE,
                'PrcItem' => $detalle['Precio'],
                'MontoItem' => $total,
            ];*/

            if(!$this->ingresaDetalle($detalle)){
                return $this->fallo('No se pudo realizar el ingreso de detalle.');
            }

        }

        return [
            'mensaje' => 'Documento generado con exito.',
            'folio' =>  $this->folio
        ];
    }

    protected function ingresoSolicitud()
    {

        $estadoSolicitud = ($this->generica) ? 2 : 1;
        $fecha_hoy = date("Y-m-d");

        try{
        $id_ingreso_lv = DB::table('ad_solicitud')
            ->insertGetId([
                'RUT_EMPRESA' => $this->rut_empresa,
                'CCOSTO' => $this->centro_costo,
                'NOTA' => $this->nota,
                'REVISADO_POR' => $this->solicitado,
                'FECHA' => $this->fecha,
                'PRIORIDAD' => $this->prioridad,
                'ESTADO' => $estadoSolicitud,
                'USUARIO' => $this->rut_usuario,
                'N_DOC' => $this->folio,
                'DESCRIPCION' => $this->descripcion_corta,
                'F_VENCIMIENTO' => $this->fecha_entrega,
                'F_INGRESO' => $fecha_hoy,
                'CBENEFICIO' => $this->centro_beneficio,
                'RUT_USUARIO' => $this->rut_usuario,
                'GENERICA' => $this->generica

            ]);
        }catch (Exception $e) {
            return false;
        }

        return $id_ingreso_lv;
    }


    protected function ingresaDetalle($detalle)
    {
        try{

            $ingreso = DB::table('ad_solicitud_det')
                ->insert([
                    'RUT_EMPRESA' => $this->rut_empresa,
                    'N_DOC' => $this->folio,
                    'CANT' => $detalle['Cantidad'],
                    'DESCRIPCION' => $detalle['Descripcion'],
                    'OBS' => isset($detalle['Descripcion']) ? $detalle['Descripcion'] : '',
                    'UNIDAD' => $detalle['Unidad'],
                    'CODIGO_I' => '',
                    'ADICIONAL' => ''
                ]);
        } catch(Exception $e) {
            return false;
        }

        return $ingreso;
    }



    protected function calculaTotalesFactura($tipoDocumento, $montoNeto, $montoExento, $descuento)
    {
        $montosTotales = [];

        if($tipoDocumento == self::NOTA_VENTA_AFECTA) {
            $montosTotales['neto'] = $montoNeto - $descuento;
            $montosTotales['exento'] = $montoExento;
            $montosTotales['iva'] = ($montoNeto - $descuento) * env('IVA');
            $montosTotales['total'] = ($montoNeto - $descuento) + $montoExento + $montosTotales['iva'];
        }

        return $montosTotales;
    }

    protected function obtenFolioSolicitudCompra()
   {
       /*$query4  =  "SELECT * FROM ad_solicitud WHERE RUT_EMPRESA='$rut_empresa'";
	$result4 = mysql_db_query($database, $query4);
	$row4 = mysql_num_rows($result4);
	$n_doc=$row4+1;*/

       $solicitud = DB::table('ad_solicitud')
            ->select('n_doc')
           ->whereRaw('RUT_EMPRESA = \''.$this->rut_empresa.'\'')
           ->max('n_doc');
           $folio = $solicitud + 1;

           return $folio;

   }

    protected function obtenDatosEmisor($rut_emisor)
   {
       return DB::table('datos_empresa')
           ->whereRaw('rut = \''.$rut_emisor.'\'')
           ->where('ESISTEMA', '=', 1)
           ->first();
   }

    protected function rollback(){
        $ingreso = DB::table('libro_ventas')
            ->whereRaw('rut = \''.$this->rut_empresa.'\'')
            ->where('typo_doc', '=', $this->tipo_documento)
            ->where('n_doc', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('ctacte')
            ->whereRaw('rut_empresa = \''.$this->rut_empresa.'\'')
            ->where('tipo_doc', '=', $this->tipo_documento)
            ->where('n_doc_ctacte', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('desc_global')
            ->whereRaw('ID_EMPRESA = \''.$this->rut_empresa.'\'')
            ->where('TIPO_DOC', '=', $this->tipo_documento)
            ->where('FOLIO_DOC', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('dir_libro_venta')
            ->whereRaw('ID_EMPRESA = \''.$this->rut_empresa.'\'')
            ->where('TIPO_DIR_LVENTA', '=', $this->tipo_documento)
            ->where('FOLIO_DIR_LVENTA', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('adicional_libro_ventas')
            ->whereRaw('RUT_EMPRESA = \''.$this->rut_empresa.'\'')
            ->where('typo_doc', '=', $this->tipo_documento)
            ->where('n_doc', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('detalle_doc2')
            ->whereRaw('RUT_EMPRESA = \''.$this->rut_empresa.'\'')
            ->where('ID_TIPODOC', '=', $this->tipo_documento)
            ->where('ID_CORRE_DETALLEDOC', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('detalle_inv_productos')
            ->whereRaw('RUT_EMPRESA = \''.$this->rut_empresa.'\'')
            ->where('FOLIO_DOC', '=', $this->tipo_documento)
            ->where('N_DOC', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('ref_sistema_ge_especial')
            ->whereRaw('RUT_EMPRESA = \''.$this->rut_empresa.'\'')
            ->where('ADICIONAL2', '=', $this->tipo_documento)
            ->where('ADICIONAL1', '=', $this->folio)
            ->delete();
    }

    protected function generaXmlNotaVenta($datos)
    {
        $xml_detalle = '';

        $item = 1;
        foreach($datos['Detalles'] as $detalle) {
            $xml_detalle .= '<Detalle>
               <NroLinDet>'.$item.'</NroLinDet>
               <CdgItem>
                  <TpoCodigo />
                  <VlrCodigo>'.$detalle['VlrCodigo'].'</VlrCodigo>
               </CdgItem>
               <NmbItem>'.$detalle['NmbItem'].'</NmbItem>
               <QtyItem>'.$detalle['QtyItem'].'</QtyItem>
               <UnmdItem>'.$detalle['UnmdItem'].'</UnmdItem>
               <PrcItem>'.$detalle['PrcItem'].'</PrcItem>
               <MontoItem>'.$detalle['MontoItem'].'</MontoItem>
            </Detalle>'.PHP_EOL;
            $item++;
        }

        $xml_no_facturable = '';
        if (!empty($datos['NO_facturable'])) {
            $valor_total_monto_no_facturable = number_format(($datos['MntTotal'] + $datos['NO_facturable']),0,',','');

            $xml_no_facturable = '<MontoNF>'.$datos['NO_facturable'].'</MontoNF>
                    <TotalPeriodo>'.$valor_total_monto_no_facturable.'</TotalPeriodo>';
            //$xml_no_facturable .= '<MontoPeriodo>'.$valor_total_monto_no_facturable.'</MontoPeriodo>';
        }


        $xml = '<DTE version="1.0">
            <Documento ID="F674T33">
               <Encabezado>
                  <IdDoc>
                     <TipoDTE>'.$datos['TipoDTE'].'</TipoDTE>
                     <Folio>'.$datos['Folio'].'</Folio>
                     <FchEmis>'.date('Y-m-d', time()).'</FchEmis>
                     <IndServicio>3</IndServicio>
                  </IdDoc>
                  <Emisor>
                     <RUTEmisor>'.$datos['RUTEmisor'].'</RUTEmisor>
                     <RznSoc>'.$datos['RznSoc'].'</RznSoc>
                     <GiroEmis>'.$datos['GiroEmis'].'</GiroEmis>
                     <Telefono>'.$datos['Telefono'].'</Telefono>
                     <Acteco>'.$datos['Acteco'].'</Acteco>
                     <DirOrigen>'.$datos['DirOrigen'].'</DirOrigen>
                     <CmnaOrigen>'.$datos['CmnaOrigen'].'</CmnaOrigen>
                     <CiudadOrigen>'.$datos['CiudadOrigen'].'</CiudadOrigen>
                  </Emisor>
                  <Receptor>
                     <RUTRecep>'.$datos['RUTRecep'].'</RUTRecep>
                     <RznSocRecep>'.$datos['RznSocRecep'].'</RznSocRecep>
                     <GiroRecep>'.$datos['GiroRecep'].'</GiroRecep>
                     <DirRecep>'.$datos['DirRecep'].'</DirRecep>
                     <CmnaRecep>'.$datos['CmnaRecep'].'</CmnaRecep>
                     <CiudadRecep>'.$datos['CiudadRecep'].'</CiudadRecep>
                  </Receptor>
                  <Totales>
                     <MntNeto>'.$datos['neto'].'</MntNeto>
                     <MntExe>'.$datos['exento'].'</MntExe>
                     <TasaIVA>'.$datos['tasaIVA'].'</TasaIVA>
                     <IVA>'.$datos['iva'].'</IVA>
                     <MntTotal>'.$datos['MntTotal'].'</MntTotal>
                     '.$xml_no_facturable.'
                  </Totales>
               </Encabezado>
               '.$xml_detalle.'

            </Documento>
         </DTE>';

         return $xml;
    }

    protected function generaXmlAdicionales($datos)
    {
        $xml = '<Adicional>
    	       <Uno>'.(isset($datos['Uno']) ? $datos['Uno'] : '').'</Uno>
    	       <Dos>'.(isset($datos['Dos']) ? $datos['Dos'] : '').'</Dos>
               <Tres>'.(isset($datos['Tres']) ? $datos['Tres'] : '').'</Tres>
               <Cuatro>'.(isset($datos['Cuatro']) ? $datos['Cuatro'] : '').'</Cuatro>
               <Cinco>'.(isset($datos['Cinco']) ? $datos['Cinco'] : '').'</Cinco>
               <Seis>'.(isset($datos['Seis']) ? $datos['Seis'] : '').'</Seis>
               <Siete>'.(isset($datos['Siete']) ? $datos['Siete'] : '').'</Siete>
               <Ocho>'.(isset($datos['Ocho']) ? $datos['Ocho'] : '').'</Ocho>
               <Nueve>'.(isset($datos['Nueve']) ? $datos['Nueve'] : '').'</Nueve>
               <Diez>'.(isset($datos['Diez']) ? $datos['Diez'] : '').'</Diez>
               <Once>'.(isset($datos['Once']) ? $datos['Once'] : '').'</Once>
               <Doce>'.(isset($datos['Doce']) ? $datos['Doce'] : '').'</Doce>
               <Trece>'.(isset($datos['Trece']) ? $datos['Trece'] : '').'</Trece>
               <Catorce>'.(isset($datos['Catorce']) ? $datos['Catorce'] : '').'</Catorce>
               <Quince>'.(isset($datos['Quince']) ? $datos['Quince'] : '').'</Quince>
               <Dieciseis>'.(isset($datos['Dieciseis']) ? $datos['Dieciseis'] : '').'</Dieciseis>
               <Diecisiete>'.(isset($datos['Diecisiete']) ? $datos['Diecisiete'] : '').'</Diecisiete>
               <Dieciocho>'.(isset($datos['Dieciocho']) ? $datos['Dieciocho'] : '').'</Dieciocho>
               <Diecinueve>'.(isset($datos['Diecinueve']) ? $datos['Diecinueve'] : '').'</Diecinueve>
               <Veinte>'.(isset($datos['Veinte']) ? $datos['Veinte'] : '').'</Veinte>
               <Veintiuno>'.(isset($datos['Veintiuno']) ? $datos['Veintiuno'] : '').'</Veintiuno>
               <Veintidos>'.(isset($datos['Veintidos']) ? $datos['Veintidos'] : '').'</Veintidos>
               <Veintitres>'.(isset($datos['Veintitres']) ? $datos['Veintitres'] : '').'</Veintitres>
               <Veinticuatro>'.(isset($datos['Veinticuatro']) ? $datos['Veinticuatro'] : '').'</Veinticuatro>
               <Veinticinco>'.(isset($datos['Veinticinco']) ? $datos['Veinticinco'] : '').'</Veinticinco>
               <Veintiseis>'.(isset($datos['Veintiseis']) ? $datos['Veintiseis'] : '').'</Veintiseis>
               <Veintisiete>'.(isset($datos['Veintisiete']) ? $datos['Veintisiete'] : '').'</Veintisiete>
               <Veintiocho>'.(isset($datos['Veintiocho']) ? $datos['Veintiocho'] : '').'</Veintiocho>
               <Veintinueve>'.(isset($datos['Veintinueve']) ? $datos['Veintinueve'] : '').'</Veintinueve>
               <Treinta>'.(isset($datos['Treinta']) ? $datos['Treinta'] : '').'</Treinta>
               <Treintayuno>'.(isset($datos['Treintayuno']) ? $datos['Treintayuno'] : '').'</Treintayuno>
               <Treintaydos>'.(isset($datos['Treintaydos']) ? $datos['Treintaydos'] : '').'</Treintaydos>
               <Treintaytres>'.(isset($datos['Treintaytres']) ? $datos['Treintaytres'] : '').'</Treintaytres>
               <Treintaycuatro>'.(isset($datos['Treintaycuatro']) ? $datos['Treintaycuatro'] : '').'</Treintaycuatro>
               <Treintaycinco>'.(isset($datos['Treintaycinco']) ? $datos['Treintaycinco'] : '').'</Treintaycinco>
               <Treintayseis>'.(isset($datos['Treintayseis']) ? $datos['Treintayseis'] : '').'</Treintayseis>
               <Treintaysiete>'.(isset($datos['Treintaysiete']) ? $datos['Treintaysiete'] : '').'</Treintaysiete>
               <Treintayocho>'.(isset($datos['Treintayocho']) ? $datos['Treintayocho'] : '').'</Treintayocho>
               <Treintaynueve>'.(isset($datos['Treintaynueve']) ? $datos['Treintaynueve'] : '').'</Treintaynueve>
               <Cuarenta>'.(isset($datos['Cuarenta']) ? $datos['Cuarenta'] : '').'</Cuarenta>
               <Cuarentayuno>'.(isset($datos['Cuarentayuno']) ? $datos['Cuarentayuno'] : '').'</Cuarentayuno>
               <Cuarentaydos>'.(isset($datos['Cuarentaydos']) ? $datos['Cuarentaydos'] : '').'</Cuarentaydos>
               <Cuarentaytres>'.(isset($datos['Cuarentaytres']) ? $datos['Cuarentaytres'] : '').'</Cuarentaytres>
               <Cuarentaycuatro>'.(isset($datos['Cuarentaycuatro']) ? $datos['Cuarentaycuatro'] : '').'</Cuarentaycuatro>
               <Cuarentaycinco>'.(isset($datos['Cuarentaycinco']) ? $datos['Cuarentaycinco'] : '').'</Cuarentaycinco>
               <Cuarentayseis>'.(isset($datos['Cuarentayseis']) ? $datos['Cuarentayseis'] : '').'</Cuarentayseis>
               <Cuarentaysiete>'.(isset($datos['Cuarentaysiete']) ? $datos['Cuarentaysiete'] : '').'</Cuarentaysiete>
               <Cuarentayocho>'.(isset($datos['Cuarentayocho']) ? $datos['Cuarentayocho'] : '').'</Cuarentayocho>
               <Cuarentaynueve>'.(isset($datos['Cuarentaynueve']) ? $datos['Cuarentaynueve'] : '').'</Cuarentaynueve>
               <Cincuenta>'.(isset($datos['Cincuenta']) ? $datos['Cincuenta'] : '').'</Cincuenta>
           </Adicional>';

       return $xml;
    }

    protected function formateaNumero($numero)
    {
        return number_format($numero, 0, ',', '');
    }
}
