<?php

namespace App\Models;

use DB;

class Cliente
{
    public static function obtenCliente($rut_cliente, $rut_empresa)
    {
        return DB::table('clienteproveedor')
            ->whereRaw('clienteproveedor.RUT_CLIENTEPROVEEDOR = \''.$rut_cliente.'\'')
            ->whereRaw('clienteproveedor.RUT_EMPRESA = \''.$rut_empresa.'\'')
            ->join('dir_clienteproveedor', function ($join) {
                $join->on('dir_clienteproveedor.RUT_CLIENTEPROVEEDOR', '=', 'clienteproveedor.RUT_CLIENTEPROVEEDOR')
                    ->on('dir_clienteproveedor.RUT_EMPRESA', '=', 'clienteproveedor.RUT_EMPRESA');
            })->first();
    }

    public static function obtenDirecciones($rut_cliente, $rut_empresa)
    {
        return DB::table('dir_clienteproveedor')
            ->select(
                'ID_DIRECCION as id',
                'DIRECCION_DIRECCION as direccion',
                'ID_COMUNA as comuna',
                'ID_CIUDAD as ciudad',
                'EMAIL_DIRECCION as email',
                'paises.descripcion as pais')
            ->whereRaw('dir_clienteproveedor.RUT_CLIENTEPROVEEDOR = \''.$rut_cliente.'\'')
            ->whereRaw('dir_clienteproveedor.RUT_EMPRESA = \''.$rut_empresa.'\'')
            ->join('paises', 'paises.codigo', '=', 'dir_clienteproveedor.ID_PAIS')
            ->get();
    }

    public static function obtenDireccion($id, $rut_cliente, $rut_empresa)
    {
        return DB::table('dir_clienteproveedor')
            ->select(
                'ID_DIRECCION as id',
                'DIRECCION_DIRECCION as direccion',
                'ID_COMUNA as comuna',
                'ID_CIUDAD as ciudad',
                'EMAIL_DIRECCION as email',
                'paises.descripcion as pais')
            ->whereRaw('dir_clienteproveedor.RUT_CLIENTEPROVEEDOR = \''.$rut_cliente.'\'')
            ->whereRaw('dir_clienteproveedor.RUT_EMPRESA = \''.$rut_empresa.'\'')
            ->where('ID_DIRECCION', '=', $id)
            ->join('paises', 'paises.codigo', '=', 'dir_clienteproveedor.ID_PAIS')
            ->first();
    }

    public static function obtenContactos($rut_cliente, $rut_empresa)
    {
        return DB::table('clienteproveedor_contacto')
            ->select(
                'idcontacto as id',
                'nombre as nombre_cto',
                'cargo as cargo_cto',
                'email as email_cto',
                'telefono_oficina as telefono_cto',
                'telefono_celular as celular_cto',
                'cobranza as cobranza_cto'
            )
            ->whereRaw('rut_cliente = \''.$rut_cliente.'\'')
            ->whereRaw('rut_empresa = \''.$rut_empresa.'\'')
            ->get();
    }

    public static function obtenContacto($id, $rut_cliente, $rut_empresa)
    {
        return DB::table('clienteproveedor_contacto')
            ->select(
                'idcontacto as id',
                'nombre as nombre_cto',
                'cargo as cargo_cto',
                'email as email_cto',
                'telefono_oficina as telefono_cto',
                'telefono_celular as celular_cto',
                'cobranza as cobranza_cto'
            )
            ->whereRaw('rut_cliente = \''.$rut_cliente.'\'')
            ->whereRaw('rut_empresa = \''.$rut_empresa.'\'')
            ->where('idcontacto', '=', $id)
            ->first();
    }
}
