<?php

namespace App\Middleware;

use DB;
use Symfony\Component\HttpFoundation\Response;
use Carbon\Carbon;

class Logger
{
    protected function agregaRegistro($rut_empresa, $rut_usuario, $proceso, $metodo, $entrada, $salida, $ambiente, $ip_cliente)
    {
        return DB::connection('log')->table('log_servicio_rest')
            ->insert([
                'rut_empresa' => $rut_empresa,
                'rut_usuario' => $rut_usuario,
                'ambiente' => $ambiente,
                'ip_cliente' => $ip_cliente,
                'proceso' => $proceso,
                'metodo' => $metodo,
                'entrada' => $entrada,
                'salida' => $salida,
                'timestamp' => (string)Carbon::now(),
            ]);
    }

    

    public function log($rut_empresa, $proceso, $metodo, $rut_usuario = '', $entrada = '', $salida = '', $ambiente = '', $ip_cliente = '')
    {
        $entrada = is_array($entrada) ? json_encode($entrada) : (string)$entrada;
        $salida = is_array($salida) ? json_encode($salida) : (string)$salida;

        return $this->agregaRegistro($rut_empresa, $rut_usuario, $proceso, $metodo, $entrada, $salida, $ambiente, $ip_cliente);
    }

    protected function agregaRegistroDte($rut_empresa, $rut_usuario, $proceso, $metodo, $entrada, $salida, $ambiente, $ip_cliente)
    {
        DB::connection('log')->table('log_rest_dte')
            ->insert([
                'rut_empresa' => $rut_empresa,
                'rut_usuario' => $rut_usuario,
                'ambiente' => $ambiente,
                'ip_cliente' => $ip_cliente,
                'proceso' => $proceso,
                'metodo' => $metodo,
                'timestamp' => (string)Carbon::now(),
            ]);
        
        DB::connection('log')->table('log_rest_dte_detalle')
        ->insert([
            'id_log_rest_dte' => $rut_empresa,
            'entrada' => $entrada,
            'salida' => $salida,
            'timestamp' => (string)Carbon::now(),
        ]);
    }

    public function logDte($rut_empresa, $proceso, $metodo, $rut_usuario = '', $entrada = '', $salida = '', $ambiente = '', $ip_cliente = '')
    {
        $entrada = is_array($entrada) ? json_encode($entrada) : (string)$entrada;
        $salida = is_array($salida) ? json_encode($salida) : (string)$salida;

        return $this->agregaRegistro($rut_empresa, $rut_usuario, $proceso, $metodo, $entrada, $salida, $ambiente, $ip_cliente);
    }
}
