<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It is a breeze. Simply tell Lumen the URIs it should respond to
| and give it the Closure to call when that URI is requested.
|
*/

$app->get('/', function () use ($app) {
    return 'Servicio Web Softnet';
});

$app->post('/login', 'LoginController@login');
$app->get('/clienteContacto', 'ClientesController@clienteContactos');

$app->group(['prefix' => 'cliente'], function() use ($app){
    $app->post('/', 'App\Http\Controllers\ClientesController@ingresar');
    $app->get('/', 'App\Http\Controllers\ClientesController@index');
    $app->post('/{rut}/direccion', 'App\Http\Controllers\ClientesController@ingresarDireccion');
    $app->get('/{rut}/direccion', 'App\Http\Controllers\ClientesController@indexDireccion');
    $app->put('/{rut}/direccion/{id}', 'App\Http\Controllers\ClientesController@actualizarDireccion');
    $app->put('/{rut}', 'App\Http\Controllers\ClientesController@actualizarcliente');
    $app->get('/{rut}', 'App\Http\Controllers\ClientesController@obtenCliente');
    $app->get('/{rut}/contacto', 'App\Http\Controllers\ClientesController@indexContacto');
    $app->post('/{rut}/contacto', 'App\Http\Controllers\ClientesController@ingresarContacto');
    $app->get('/{rut}/contacto/{id}', 'App\Http\Controllers\ClientesController@obtenContacto');
    $app->put('/{rut}/contacto/{id}', 'App\Http\Controllers\ClientesController@actualizarContacto');
    $app->put('/{rut}/clienteDireccion', 'App\Http\Controllers\ClientesController@actualizarClienteDireccion');

});
$app->get('/proveedor', 'ClientesController@listarProveedores');


$app->get('/clienteDireccion', 'ClientesController@getClienteDireccion');


$app->get('/paneldteEntrada', 'PanelDTEController@getBandejaEntrada');
$app->get('/paneldteHistorial', 'PanelDTEController@getHistorial');

$app->post('/libroCompras', 'LibroController@getLibroCompras');
$app->get('/libroComprasCliente/{rut}', 'LibroController@getLibroComprasCliente');

$app->post('/libroCotizacion', 'LibroController@getLibroCotizacion');
$app->post('/CotizacionPorProducto', 'LibroController@getCotizacionPorProducto');//ok
$app->post('/libroNotaVenta', 'LibroController@getLibroNotaVenta');//ok
$app->get('/libroNotaVenta/{fecha}', 'LibroController@getLibroNotaVentaFecha');
$app->post('/libroGuias', 'LibroController@getLibroGuias');//ok
$app->post('/libroVentas', 'LibroController@getLibroVentas');//ok
$app->post('/libroVentas/{rut}', 'LibroController@getLibroVentasDetalle');//ok

$app->post('/libroVentasDetalle', 'LibroController@getLibroVentasConDetalle');
$app->post('/libroVentasDetallePorFecha', 'LibroController@getLibroVentasConDetallePorFecha');

//$app->post('/libroVentas/{tipo_doc}', 'LibroController@getLibroVentasPorTipo');#add doc
$app->post('/libroOrdenCompra', 'LibroController@getLibroOrdenCompra');//ok

$app->post('/procesaTxt', 'FacturacionController@generaTxtXml'); //pendiente

$app->post('/solicitudCompra', 'FacturacionController@ingresarSolicitudCompra');

$app->post('/cotizacion', 'FacturacionController@ingresarCotizacion');
$app->post('/notaVenta', 'FacturacionController@ingresarNotaVenta');//ok
$app->post('/ordenCompra', 'FacturacionController@ingresarOrdenCompra');
$app->post('/factura', 'FacturacionController@ingresarFactura');//ok
$app->post('/notaCredito', 'FacturacionController@ingresarNotaCredito');        #add doc
$app->post('/boleta', 'FacturacionController@ingresarBoleta');
$app->post('/boletaNew', 'FacturacionController@ingresarBoletaNew');
$app->post('/boleta2', 'FacturacionController@ingresarBoleta2');

$app->post('/solicitudCesion', 'CesionController@ingresarSolicitudCesion');
$app->post('/enviaCesion', 'CesionController@enviaSolicitudCesion');

$app->post('/woopy', 'FacturacionController@ingresarWoopy');
$app->post('/ecomerce', 'FacturacionController@ingresarEcomerce');
$app->post('/pedido', 'FacturacionController@ingresarPedido');
$app->post('/boletajumpseller', 'FacturacionController@ingresarPedidoJumpseller');
$app->post('/boletaMasiva', 'FacturacionController@ingresarBoletaMasiva'); //pendiente
$app->post('/guiaDespacho', 'FacturacionController@ingresarGuiaDespacho');//ok

$app->post('/guiaAjuste', 'AjusteController@ingresarGuiaAjuste');//ok
$app->get('/guiaAjuste', 'AjusteController@index');//ok

//$app->post('/pago', 'PagoController@ingresarPago');


$app->post('/prefactura', 'FacturacionController@ingresarPrefacturaV2');
$app->post('/nupypro', 'FacturacionController@ingresarNupyPro');


//actualziar estados documento
$app->post('/estadoCotizacion', 'FacturacionController@actualizaEstadoCotizacion');


//ADMIN
$app->group(['prefix' => 'admin'], function() use ($app){
    $app->get('/caf', 'App\Http\Controllers\CafController@ConsultaCaf');
    //$app->post('/subircaf', 'App\Http\Controllers\CafController@SubirCaf');
    
});

$app->get('/cargarcaf/{tipo}', 'CafController@cargarCaf');


$app->post('/consultaDocumento', 'FacturacionController@consultarFolio');
$app->post('/consultaDTE', 'FacturacionController@consultaDTE');
$app->post('/consultaDTETermico', 'FacturacionController@consultaDTETermico');
$app->post('/consultaDTE_datos', 'FacturacionController@consultaDTEDatos');      //no incluido, revisar
$app->post('/consultaRango', 'FacturacionController@consultarDocumentos');

$app->post('/envioDocumento', 'MailController@evioMailDocumento'); //no incluido

$app->get('/areaNegocio', 'AreaNegocioController@index');
$app->get('/centroCosto', 'CentroCostoController@index');
$app->get('/clasificacionCompra', 'ClasificacionCompraController@index');


$app->get('/producto', 'ProductoController@index');//ok
$app->get('/productoMaestro', 'ProductoController@maestro');
$app->post('/producto', 'ProductoController@ingresar');
$app->put('/producto/{codigo}', 'ProductoController@actualizar');

$app->get('/productoActivos', 'ProductoController@productoActivos');
$app->get('/productoActivos2', 'ProductoController@productoActivos2');
$app->get('/productoActivos3', 'ProductoController@productoActivos3');

$app->get('/listaPrecios', 'ProductoController@listaPrecios');



//snl
$app->get('/productoPack', 'ProductoController@productos_pack');
$app->get('/productoNoPack', 'ProductoController@productos_no_pack');
$app->get('/productoNoPackCosto/{codigo}', 'ProductoController@productos_no_pack_costo');
//snl

$app->get('/productoCosto', 'ProductoController@costo_por_producto');//ok
//revisar
$app->get('/productoWeb', 'ProductoController@productosPaginaWeb');//ok#add doc -> revisar funcion
$app->get('/productoWebBodega/{id_bodega}', 'ProductoController@productosPaginaWebBodega');
$app->get('/imagenProductos', 'ProductoController@imagenProductos');
$app->get('/productoWebStockPositivo', 'ProductoController@productosPaginaWebStockPositivo');   #add doc
$app->get('/producto/{id_bodega}', 'ProductoController@productoBodega');       //ok #add doc
$app->get('/productoCodigo/{codigo}', 'ProductoController@getProducto');

//$app->get('/producto/{codigoProducto}', 'ProductoController@getProducto');


$app->get('/preciowoopy', 'ProductoController@preciowoopy');
$app->get('/stockwoopy', 'ProductoController@stockwoopy');


//productos_b
//stock por bodega
$app->get('/productoBodega/{producto}', 'ProductoController@productos_b_Bodega');



$app->get('/noticia', 'NoticiaController@index');//ok
$app->get('/campana', 'CampanaController@index');//ok
$app->get('/pregunta', 'PreguntaController@index');//ok

/*datos woopy*/
$app->get('/datosGenerales', 'DatoWebController@generales');
$app->get('/datosSociales', 'DatoWebController@redes_sociales');
$app->get('/contactoWeb', 'DatoWebController@conctacto');
$app->get('/sucursal', 'DatoWebController@sucursales');
$app->get('/bannerPrincipal', 'DatoWebController@enunciado_principal');
$app->get('/paginas', 'DatoWebController@paginas');
$app->get('/noticias', 'DatoWebController@noticias');


/*datos woopy*/


$app->get('/bodega', 'BodegaController@index');
$app->post('/bodega', 'BodegaController@ingresar');
$app->put('/bodega/{bodega_id}', 'BodegaController@actualizarBodega');
$app->get('/bodega/{id_sucursal}', 'BodegaController@bodegasPorSucursal');
$app->get('/datoSucursal/{id_sucursal}', 'SistemaController@datoSucursal');

$app->get('/formaPago', 'FormaPagoController@index');//ok
$app->get('/formaPagoPos', 'FormaPagoController@getFormasPagoPos');

$app->get('/guiaAjusteAgrupado', 'AjusteController@indexAgrupado');//ok
$app->get('/unidadMedida', 'UnidadMedidaController@index');//ok

$app->get('/vendedores', 'VendedoresController@index');//ok
$app->get('/vendedores/{rut}', 'VendedoresController@obtenVendedor');//ok
$app->put('/vendedores/{rut}', 'VendedoresController@actualizarVendedor');//ok
$app->post('/vendedores', 'VendedoresController@ingresarVendedor');

$app->get('/trabajadores', 'TrabajadoresController@index');//ok


$app->post('/masterReport', 'InventarioController@getMasterReport');//especial//ok
$app->post('/masterReportDetalle', 'InventarioController@getMasterReportDetalle');//especial//ok

$app->get('/datoUsuario', 'SistemaController@datosUsuario');//no agregar por seguridad
$app->get('/listaUsuarios', 'SistemaController@listaUsuarios');//no agregar por seguridad
$app->get('/datoUsuario/{username}', 'SistemaController@getUsuario');

$app->get('/configuracionProducto', 'SistemaController@obtenerConfiguracionProducto');//ok
$app->get('/datoEmpresa', 'SistemaController@datosEmpresa');//ok
$app->get('/logoEmpresa', 'SistemaController@logoEmpresa');//ok
$app->get('/informacionEmpresa', 'SistemaController@informacionEmpresa');
$app->get('/confFlujoPago', 'FlujoPagoController@index');

$app->get('/informes/comprasPorPagar', 'ComprasController@obten_compras_por_pagar');//ok
$app->get('/informes/comprasPorPagar/{rut}', 'ComprasController@obtenComprasPorPagarPorProveedor');//ok

$app->get('/informes/ventasPorDia/{fecha}', 'VentasController@obten_ventas_por_dia');
$app->post('/informes/ventasPorMes', 'VentasController@obten_ventas_por_mes');
$app->post('/informes/ventasPorMesProducto/{codigo}', 'VentasController@obten_ventas_por_mes_por_producto');
$app->get('/informes/ventasPorCobrar', 'VentasController@obten_ventas_por_cobrar');//ok
$app->get('/informes/ventasPorCobrar/{rut}', 'VentasController@obtenVentasPorCobrarPorCliente');//ok


$app->get('/marca', 'MarcaProductosController@index');
$app->get('/familia', 'FamiliaProductosController@index'); //ok
$app->get('/linea_productos', 'LineaProductosController@index');//ok
$app->get('/transporte', 'TransporteController@index');#obsoleto

$app->post('/ticket', 'TicketController@ingresarTicket'); #ingreso de ticket servicio tec. comaco

$app->get('/bancos', 'BancoController@index');//ok
$app->get('/listaBancos', 'BancoController@listaBancos');//ok
