<?php

namespace App\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use DB;
use Log;

class LoginController extends Controller
{
    public function login(Request $request)
    {
        $this->validateJson($request, [
           'username' => 'required',
           'password' => 'required',
           'rut' => 'required|rut',
        ]);
        $datos = $request->json()->all();

        Log::info('Datos recibidos: '.json_encode($datos));


	    $estado_modulo = DB::table('modulos_empresas')
            ->where('ID_EMPRESA', '=', $datos['rut'])
            ->where('MODULO17', '=', 1 )
            ->first();

        $datos_empresa = DB::table('datos_empresa')
            ->where('rut', '=', $datos['rut'])
            ->first();

	    if (empty($estado_modulo->MODULO17)) {
            return new JsonResponse([
                'mensaje' => 'Modulo Inactivo',
            ], 401);
        }

        $id_empresa = DB::table('datos_empresa')
            ->where('rut', '=', $datos['rut'])
            ->where('ESISTEMA', '=', 1)
            ->first();
        $id_empresa = $id_empresa->ID;

        $login = DB::table('datos_usuarios')
            ->where('rut', '=', $datos['rut'])
            ->where('user', '=', $datos['username'])
            ->first();

        if (!is_null($login) && password_verify($datos['password'], $login->pass)) {
            $token = $this->generaToken($login->user);

            DB::table('token_usuario')->insert([
                [
                    'token' => $token,
                    'fcreacion' => date('Y-m-d H:i:s', time()),
                    'fclaudica' => date('Y-m-d H:i:s', time() + (60 * 60)),
                    'id_empresa' => $id_empresa,
                    'rut_empresa' => $login->rut,
                    'id_empresa' => $datos_empresa->ID,
                    'rut_usuario' => $login->rut_p,
                ],
            ]);

            Log::info('Token Generado: '.$token);

            return new JsonResponse([
                'token' => $token,
            ]);
        }

        return new JsonResponse([
            'mensaje' => 'Credenciales Invalidas',
        ], 401);
    }

    private function generaToken($usuario)
    {
        $cadena = (string) time();
        $cadena .= $usuario;

        return hash('sha512', $cadena);
    }
}
