<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\Autenticable;
use DB;

class UnidadMedidaController extends Controller
{
    use Autenticable;

    public function index(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $unidades = DB::table('umedida')
            ->select('ID_UMEDIDA as id', 'NOMBRE_UMEDIDA as nombre')
            ->get();

        return response()->json((array) $unidades);
    }
}
