<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\Autenticable;
use DB;
use App\Models\Trabajador;

class TrabajadoresController extends Controller
{
    use Autenticable;

    public function index(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $unidades = DB::table('trabajadores')
            ->select('RUT2','APELLIDO_PATERNO','APELLIDO_MATERNO','NOMBRES','FECHA_NACIMIENTO','ESTADO_CIVIL','DIRECCION','COMUNA','region','TELEFONO_FIJO','TELEFONO_CELULAR','EMAIL','N_CARGAS','ESTADO_CTO','TIPO_CONTRATO','SUELDO_BASE','TIPO_GRATIFICACION','COLACION','MOVILIZACION','CARGAS_A_F','SEGURO_CESANTIA','pensionado','subsidio_trabajador_joven','comuna_prestacion_servicios_principal','discapacidad_pensionado_invalidez','tipo_trabajador','TRAMO_A_F','AFP','APV_AFP','PREVISION_SALUD','T_CONTRATO_SALUD','PACTADO_1','PACTADO_2','PACTADO_3','fpago_apvi','ID_CARGO','ciudad','id_centrocosto','departamento','rol_privado','ano_otros_emp','num_tar_control_h','cer_renta','sujeto_control_h','porc_costo_admin','unidad_coti_vol','id_caja_comp','codigo_institucion','numero_contrato','rebaja_impuesto','id_situacion_m','id_estudios','banco','tipo_cuenta','num_cuenta','forma_pago','nacionalidad','sexo','estado','apv_libro_rem' )
            ->whereRaw('RUT = \''.$usuario->rut_empresa.'\'')
            ->get();

        return response()->json((array) $unidades);
    }


}
