<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\Autenticable;
use DB;
use Logger;
use App\Models\NotaCredito;
use App\Models\GuiaDespacho;

use App\Traits\Integrable;
use App\Traits\Foliable;
use App\Traits\Documentable;
use App\Models\Producto;
use App\Models\Cliente;
use App\Models\Bodega;

class NotaDeCreditoController extends Controller
{
	use Autenticable;
    use Foliable;
    use Integrable;
    use Documentable;

	public function ingresarNotaDeCreadito(Request $request){

        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);

        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        
        $item = 0;
        $respuestas = [];

        

        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            $datos,
            $respuestas,
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        

        foreach($datos as $notaCredito) {



            $respuesta = [];
            try{
                $this->validateArray($request, $notaCredito, [
                    'Encabezado' => 'required|array',
                    'Encabezado.Receptor' => 'required|rut',
                    'Encabezado.MontoNeto' => 'required|numeric|min:0',
                    'Encabezado.MontoExento' => 'required|numeric|min:0',
                    'Encabezado.Descuento' => 'required|numeric|min:0',
                    'Encabezado.TipoDocumento' => 'required|integer',
                    'Encabezado.AreaNegocio' => 'required|numeric',
                    'Encabezado.Observacion' => 'sometimes|required|max:255',
                    'Encabezado.Direccion' => 'sometimes|required|integer',

                    'Detalle' => 'required|array',
                    'Detalle.*.Codigo' => 'required',
                    'Detalle.*.Precio' => 'sometimes|required|numeric|min:0',
                    'Detalle.*.Cantidad' => 'required|integer|min:1',
                    'Detalle.*.Descuento' => 'required|numeric|min:0',
                    'Detalle.*.Afecto' => 'required|boolean',
                    'Detalle.*.Bodega' => 'required|integer',

                    'Adicional.Uno' => 'required|integer', //Forma de Pago
                    'Adicional.Dos' => 'required|rut',//Vendedor
                    'Adicional.Treinta' => 'sometimes|required|numeric|min:0', //donacion

                    'Referencias.*.NroLinRef'=>'required|integer',
                    'Referencias.*.TpoDocRef'=>'required|integer|in:33,34,39,56',
                    'Referencias.*.FolioRef'=>'required|integer',
                    'Referencias.*.FchRef'=>'required|date',
                    'Referencias.*.CodRef'=>'required|integer',
                    'Referencias.*.RazonRef'=>'required|integer',
                    
                ]);
            }catch(Exception $e) {
                $respuestas[$item] = (array) $e->getResponse()->getData();
                continue;
            }

            $notadecredito = new NotaCredito(
                $usuario->rut_empresa,
                $usuario->rut_usuario,
                $notaCredito['Encabezado']['Receptor'],
                $notaCredito['Encabezado']['MontoNeto'],
                $notaCredito['Encabezado']['MontoExento'],
                $notaCredito['Encabezado']['Descuento'],
                $notaCredito['Encabezado']['TipoDocumento'],
                $notaCredito['Encabezado']['AreaNegocio'],
                $notaCredito['Encabezado']['Observacion'],
                isset($notaCredito['Encabezado']['Direccion']) ? $notaCredito['Encabezado']['Direccion'] : NULL,
                $notaCredito['Detalle'],
                $notaCredito['Referencia'],
                $notaCredito['Adicional']
            );
            
            $respuestas[$item] = $notadecredito->ingresaNotaCredito();

           

            Logger::log(
                $usuario->rut_empresa,
                $request->path(),
                $request->method(),
                $usuario->rut_usuario,
                json_encode($notaCredito),
                $respuestas[$item],
                ENV('AMBIENTE_SII'),
                $request->ip()
            );
        }
        return response()->json($respuestas);
    }
    



   
}
