<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\Autenticable;
use DB;

class LineaProductosController extends Controller
{
    use Autenticable;

    public function index(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $lineas = DB::table('producto_subfamilia')
            ->select(
                'idsubfamilia as id',
                'orden as orden',
                'nombre_subfamilia as nombre_linea',
                'estado as estado'
            )->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
            ->get();

        $datos_lineas = array();

        foreach ($lineas as $key => $value) {
            $estado = 0;
            if ($value->estado == 'ACTIVADA') {
                $estado = 1;
            }

            $datos = [
                'id' => $value->id,
                'orden' => $value->orden,
                'nombre' => $value->nombre_linea,
                'estado' => $estado,
            ];

            array_push($datos_lineas, $datos);

        }

        return response()->json($datos_lineas);

    }

}
