<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\Autenticable;
use DB;

use App\Models\Producto;

class InventarioController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
     use Autenticable;

     public function getMasterReport(Request $request)
     {
         $datos = $request->json()->all();
         $token = $request->header('token');

         $usuario = $this->valida_token($token);
         if (is_null($usuario)) {
             return $this->tokenInvalido();
         }

         $item = 0;
         $respuestas = [];
         try{
             $this->validateArray($request, $datos, [
                 'fecha_inicio' => 'required|min:4',
                 'fecha_termino' => 'required|min:4',
             ]);
         }catch(Exception $e) {
             $respuestas[$item] = (array) $e->getResponse()->getData();
         }

        $master_report = DB::table('libro_ventas')
        ->select('DETALLE_DETALLEDOC','CPROD_DETALLEDOC','CANTIDAD_DETALLEDOC','TOTAL_DETALLEDOC','rut','typo_doc','valor_t','n_doc','fecha','rut_c','nombre_c')
            ->Join('detalle_doc2', function($sql) {
                $sql->on('detalle_doc2.RUT_EMPRESA', '=', 'libro_ventas.rut');
                $sql->on('detalle_doc2.ID_TIPODOC','=','libro_ventas.typo_doc');
                $sql->on('detalle_doc2.ID_CORRE_DETALLEDOC','=','libro_ventas.n_doc');
            })

            ->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('fecha >= \''.$datos['fecha_inicio'].'\'')
            ->whereRaw('fecha <= \''.$datos['fecha_termino'].'\'')
            ->get();

        $costosProductos = $this->CostoProducto($usuario,$master_report);

        $datos_master = array();
        foreach ($master_report as $key => $value) {
            $detalle_datos_master['CPROD_DETALLEDOC'] = (string)$value->CPROD_DETALLEDOC;
            $detalle_datos_master['DETALLE_DETALLEDOC'] = $value->DETALLE_DETALLEDOC;
            $detalle_datos_master['CANTIDAD_DETALLEDOC'] = $value->CANTIDAD_DETALLEDOC;
            $detalle_datos_master['TOTAL_DETALLEDOC'] = $value->TOTAL_DETALLEDOC;
            $detalle_datos_master['rut'] = $value->rut;
            $detalle_datos_master['typo_doc'] = $value->typo_doc;
            $detalle_datos_master['valor_t'] = $value->valor_t;
            $detalle_datos_master['n_doc'] = $value->n_doc;
            $detalle_datos_master['fecha'] = $value->fecha;
            $detalle_datos_master['rut_c'] = $value->rut_c;
            $detalle_datos_master['nombre_c'] = $value->nombre_c;

            if (empty($costosProductos[$value->CPROD_DETALLEDOC])) {
                $detalle_datos_master['costo_prod'] = 0;
            }else{
                $detalle_datos_master['costo_prod'] = round($costosProductos[$value->CPROD_DETALLEDOC], 3);
            }
            $datos_master[] = $detalle_datos_master;
            unset($detalle_datos_master);
        }

        return response()->json($datos_master);
     }

     public function getMasterReportDetalle(Request $request)
     {
         $datos = $request->json()->all();
         $token = $request->header('token');

         $usuario = $this->valida_token($token);
         if (is_null($usuario)) {
             return $this->tokenInvalido();
         }

         $item = 0;
         $respuestas = [];
         try{
             $this->validateArray($request, $datos, [
                 'fecha_inicio' => 'required|min:4',
                 'fecha_termino' => 'required|min:4',
             ]);
         }catch(Exception $e) {
             $respuestas[$item] = (array) $e->getResponse()->getData();
         }

        $master_report = DB::table('libro_ventas')
        ->select('libro_ventas.n_doc','typo_doc','NOMBRE_AREANEGOCIO','NOMBRE_VENDEDOR','fecha','rut_c','nombre_c','DIRECCION_DIRECCION',
'ID_COMUNA','ID_CIUDAD','CPROD_DETALLEDOC','DETALLE_DETALLEDOC','CANTIDAD_DOC','VALOR_PRODUCTO','EXENTO_DETALLEDOC','DESC__DETALLEDOC','TOTAL_DETALLEDOC','valor_n','LOTE','F_VENCIMIENTO','ADICIONAL2_DETALLE_INV')


            ->leftJoin('dir_libro_venta', function($sql) {
                $sql->on('dir_libro_venta.ID_EMPRESA', '=', 'libro_ventas.rut');
                $sql->on('dir_libro_venta.TIPO_DIR_LVENTA','=','libro_ventas.typo_doc');
                $sql->on('dir_libro_venta.FOLIO_DIR_LVENTA','=','libro_ventas.n_doc');
            })
            ->leftJoin('dir_clienteproveedor', 'dir_libro_venta.ID_DIRECCION', '=', 'dir_clienteproveedor.ID_DIRECCION')

            ->Join('detalle_doc2', function($sql) {
                $sql->on('detalle_doc2.RUT_EMPRESA', '=', 'libro_ventas.rut');
                $sql->on('detalle_doc2.ID_TIPODOC','=','libro_ventas.typo_doc');
                $sql->on('detalle_doc2.ID_CORRE_DETALLEDOC','=','libro_ventas.n_doc');
            })

            ->leftJoin('detalle_inv_productos', function($sql) {
                $sql->on('detalle_inv_productos.RUT_EMPRESA', '=', 'libro_ventas.rut');
                $sql->on('detalle_inv_productos.FOLIO_DOC','=','libro_ventas.typo_doc');
                $sql->on('detalle_inv_productos.N_DOC','=','libro_ventas.n_doc');
                $sql->on('detalle_inv_productos.CODIGO_PRODUCTO','=','detalle_doc2.CPROD_DETALLEDOC');
                $sql->on('detalle_inv_productos.CANTIDAD_DOC','=','detalle_doc2.CANTIDAD_DETALLEDOC');
            })

            ->leftJoin('adicional_inventario', 'detalle_inv_productos.ID_DETALLE', '=', 'adicional_inventario.ID_GEN')

            ->leftJoin('vendedores', function($sql) {
                $sql->on('vendedores.RUT_EMPRESA', '=', 'libro_ventas.rut');
                $sql->on('vendedores.RUT_VENDEDOR','=','libro_ventas.DISPONIBLE2_LVENTA');
            })

            ->leftJoin('areanegocio', 'libro_ventas.ANEGOCIO_LVENTA', '=', 'areanegocio.ID_AREANEGOCIO')


            ->whereRaw('libro_ventas.rut = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('libro_ventas.fecha >= \''.$datos['fecha_inicio'].'\'')
            ->whereRaw('libro_ventas.fecha <= \''.$datos['fecha_termino'].'\'')
            //->whereRaw('libro_ventas.n_doc = \'9675\'')
            ->whereRaw('libro_ventas.typo_doc IN (33,61,56) ')
            ->groupBy('detalle_doc2.ID_DETALLEDOC')
            ->get();


        $costosProductos = $this->CostoProducto($usuario,$master_report);

        $datos_master = array();
        $cont = 1;
        foreach ($master_report as $key => $value) {

            $detalle_datos_master['num'] = $cont++;
            $detalle_datos_master['n_doc'] = $value->n_doc;
            $detalle_datos_master['typo_doc'] = $value->typo_doc;
            $detalle_datos_master['fecha'] = $value->fecha;
            $detalle_datos_master['rut_c'] = $value->rut_c;
            $detalle_datos_master['nombre_c'] = $value->nombre_c;
            if ( empty($value->NOMBRE_AREANEGOCIO)) {
                $detalle_datos_master['area_negocio'] = "Sin dato";
            }else{
                $detalle_datos_master['area_negocio'] = $value->NOMBRE_AREANEGOCIO;
            }

            if ( empty($value->NOMBRE_VENDEDOR) ) {
                $detalle_datos_master['nombre_vendedor'] = "Sin dato";
            }else{
                $detalle_datos_master['nombre_vendedor'] = $value->NOMBRE_VENDEDOR;
            }
            $detalle_datos_master['direccion'] = $value->DIRECCION_DIRECCION;
            $detalle_datos_master['comuna'] = $value->ID_COMUNA;
            $detalle_datos_master['ciudad'] = $value->ID_CIUDAD;

            //DETALLES
            $detalle_datos_master['CPROD_DETALLEDOC'] = (string)$value->CPROD_DETALLEDOC;
            $detalle_datos_master['DETALLE_DETALLEDOC'] = $value->DETALLE_DETALLEDOC;


            /*$dato_inventario = DB::table('detalle_inv_productos')
            ->select('LOTE','F_VENCIMIENTO','ADICIONAL2_DETALLE_INV')
            ->leftJoin('adicional_inventario', 'detalle_inv_productos.ID_DETALLE', '=', 'adicional_inventario.ID_GEN')

            ->whereRaw('detalle_inv_productos.RUT_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('detalle_inv_productos.FOLIO_DOC = \''.$value->typo_doc.'\'')
            ->whereRaw('detalle_inv_productos.N_DOC = \''.$value->n_doc.'\'')
            ->get();*/

            //dd($dato_inventario);

            if (empty($value->LOTE)) {
                $detalle_datos_master['dato_lote'] = 'Sin dato';
            }else {
                $detalle_datos_master['dato_lote'] = $value->LOTE."AAAA";
            }

            $detalle_datos_master['dato_vencimiento'] = empty($value->F_VENCIMIENTO) ? 'Sin dato' : $value->F_VENCIMIENTO;

            $detalle_datos_master['cantidad_detalle'] = $value->typo_doc == 61 ? (-1) * $value->CANTIDAD_DOC : $value->CANTIDAD_DOC;
            if($value->VALOR_PRODUCTO == 0){
                $valor_producto = $value->EXENTO_DETALLEDOC;
            }else{
                $valor_producto = $value->VALOR_PRODUCTO;
            }
            $detalle_datos_master['valor_producto'] = $valor_producto;

            $detalle_datos_master['descuento_x_detalle'] = $value->DESC__DETALLEDOC;

            $valor_total_detalle = $value->typo_doc == 61 ? (-1) * $value->TOTAL_DETALLEDOC : $value->TOTAL_DETALLEDOC;
            $detalle_datos_master['total_valor_producto'] = $valor_total_detalle;

            //DETALLES

            $detalle_datos_master['total_global_descuento'] = 0;
            $detalle_datos_master['valor_neto'] = $value->valor_n;

            if (empty($costosProductos[$value->CPROD_DETALLEDOC])) {
                $detalle_datos_master['costo_producto'] = 0;
            }else{
                $detalle_datos_master['costo_producto'] = round($costosProductos[$value->CPROD_DETALLEDOC], 3);
            }

            $detalle_datos_master['total_costo'] = $detalle_datos_master['costo_producto'] * $detalle_datos_master['cantidad_detalle'];
            $detalle_datos_master['margen'] = $detalle_datos_master['total_valor_producto'] - $detalle_datos_master['total_costo'];

            if (!empty($valor_total_detalle)) {
                $detalle_datos_master['porcentaje_margen'] = (($detalle_datos_master['margen'] * 100) / $valor_total_detalle);
            }else{
                $detalle_datos_master['porcentaje_margen'] = 0;
            }
            $detalle_datos_master['costo_x_lote'] = $value->ADICIONAL2_DETALLE_INV; //sql inv
            $detalle_datos_master['total_costo_x_lote'] = $detalle_datos_master['costo_x_lote'] * $detalle_datos_master['cantidad_detalle'];

            $detalle_datos_master['margen_x_lote'] = $detalle_datos_master['total_valor_producto']-$detalle_datos_master['total_costo_x_lote'];
            $detalle_datos_master['porcentaje_margen_x_lote'] = 0;


            $datos_master[] = $detalle_datos_master;
            unset($detalle_datos_master);
        }

        return response()->json($datos_master);
     }

     protected function CostoProducto($usuario,$master_report)
     {
        $conf_productos = Producto::configuracionProductos($usuario->rut_empresa);
        $todosProductos = Producto::obtenTodosProducto($usuario->rut_empresa);

        $listadoProductos = array();
        foreach ($master_report as $key => $value) {

            if (empty($listadoProductos)) {
                $listadoProductos = array($value->CPROD_DETALLEDOC);
            }else {
                if (!in_array($value->CPROD_DETALLEDOC, $listadoProductos)) {
                    array_push($listadoProductos,$value->CPROD_DETALLEDOC);
                }
            }
        }

        $fecha = date("Y-m-d");
        $datos = array();
        $costo_productos = array();
        $costo_prod = 0;
        $ultimo_costo_ingresado[0] = 0;

        foreach ($listadoProductos as $key => $value) {

            //cantidad de meses
            if (!empty($conf_productos[0]->N_MESES_COSTO)) {
                $numero_meses = $conf_productos[0]->N_MESES_COSTO;
                list($year,$mon,$day) = explode('-',$fecha);
                $fecha_inicio = date('Y-m-d',mktime(0,0,0,$mon-$numero_meses,$day,$year));

                $costo_prod = DB::table('detalle_inv_productos')
                    ->whereRaw('RUT_EMPRESA = \''.strtoupper($usuario->rut_empresa).'\'')
                    ->whereRaw('TIPO_MOV = 1')
                    ->whereRaw('CODIGO_PRODUCTO = \''.$value.'\'')
                    ->whereRaw('ADICIONAL2_DETALLE_INV <> \''.null.'\'')
                    ->whereRaw('ADICIONAL2_DETALLE_INV <> 0')
                    ->whereRaw('FECHA_INGRESO >= \''.$fecha_inicio.'\'')
                    ->avg('ADICIONAL2_DETALLE_INV');

                    $datos[$value] = $costo_prod;

            }elseif( !empty($conf_productos[0]->ULTIMA_GUIA_AJUSTE) ) {
                //ultima guia ingresada
                $costo_prod = 0;

                $ultimo_costo_ingresado = DB::table('detalle_inv_productos')
                    ->select('ADICIONAL2_DETALLE_INV')
                    ->whereRaw('RUT_EMPRESA = \''.strtoupper($usuario->rut_empresa).'\'')
                    ->whereRaw('FOLIO_DOC = 500')
                    ->whereRaw('TIPO_MOV = 1')
                    ->whereRaw('CODIGO_PRODUCTO = \''.$value.'\'')
                    ->whereRaw('ADICIONAL2_DETALLE_INV <> \''.null.'\'')
                    ->whereRaw('ADICIONAL2_DETALLE_INV > 0')
                    ->orderBy('N_DOC', 'desc')
                    ->limit(1)
                    ->get();
                    //->avg('ADICIONAL2_DETALLE_INV');

                    if (!empty($ultimo_costo_ingresado[0]->ADICIONAL2_DETALLE_INV)) {
                        $costo_prod = $ultimo_costo_ingresado[0]->ADICIONAL2_DETALLE_INV;
                    }


            }else {
                $costo_prod = DB::table('detalle_inv_productos')
                ->whereRaw('RUT_EMPRESA = \''.strtoupper($usuario->rut_empresa).'\'')
                ->whereRaw('TIPO_MOV = 1')
                ->whereRaw('CODIGO_PRODUCTO = \''.$value.'\'')
                ->whereRaw('ADICIONAL2_DETALLE_INV <> \''.null.'\'')
                ->whereRaw('ADICIONAL2_DETALLE_INV <> 0')
                ->avg('ADICIONAL2_DETALLE_INV');

            }

            $datos[$value] = $costo_prod;
        }

        return $datos;
    }

}
