<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Traits\Autenticable;
use DB;
use Illuminate\Http\JsonResponse;
use GuzzleHttp\Client;
use App\Api\AbstrahereApi;


class CafController extends Controller
{
    use Autenticable;

    public function ConsultaCaf(Request $request){

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $administrador = DB::table('Submodulos')
                ->where('ID_EMPRESA', '=', $usuario->rut_empresa )
                ->where('ID_USUARIO', '=', $usuario->rut_usuario )
                ->where('DUB', '=', 'ADMIN' )
                ->first();

        if (empty($administrador)) {
            return new JsonResponse([
                'mensaje' => 'Usuario '.$usuario->rut_usuario.' sin permiso de administrador',
            ], 401);
        }

        $hoy = date('Y-m-d');
        //$tipos = '(110,111,112,33,34,39,41,52,56,61)';
        $corre_folios = DB::table('corre_folios')
                ->where('RUT_EMPRESA', '=', $usuario->rut_empresa )
                ->whereIn('CODIGO', [110,111,112,33,34,39,41,52,56,61])
                ->get();
        //dd($corre_folios);

        $folios = array();
        foreach ($corre_folios as $key => $value) {

            $tipo_codigo = $value->CODIGO;
            $folio_siguiente = $value->FOLIO;

            $caf = DB::table('caf')
                ->select('TIMBRAJE', 'DESDE', 'HASTA','FECHA_VENCIMIENTO' )
                ->where('RUT_EMPRESA', '=', $usuario->rut_empresa )
                ->where('CODIGO_DOC', '=', $tipo_codigo)
                ->get();

                //33, 56, 61, vencen

            $listaCaf = array();
            foreach ($caf as $key => $c) {
                $tipos_excluidos = array('110','111','112','52','41','34','39');
                if (in_array($tipo_codigo, $tipos_excluidos)) {
                    array_push($listaCaf, $c);
                }else{
                    if ($hoy < $c->FECHA_VENCIMIENTO ) {
                        array_push($listaCaf, $c);
                    }
                }
            }

            $folios[$tipo_codigo]['codigo'] = $tipo_codigo;
            $folios[$tipo_codigo]['ultimo_generado'] = $folio_siguiente -1 ;
            $folios[$tipo_codigo]['folio_siguiente'] = $folio_siguiente;
            $folios[$tipo_codigo]['caf'] = $listaCaf;

        }

        return response()->json((array) $folios);

    }

    public function cargarCaf(Request $request,$tipo){

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }
        
        $cantidad = 0;
        
        //$metodo = "/cafsii/76017114-K/".$tipo;
        try {
            $metodo = "/cafsii/".$usuario->rut_empresa."/".$tipo;
            $api = new AbstrahereApi($usuario->rut_empresa,$usuario->rut_usuario);
            $documento = $api->GET($metodo);
            $respuesta = $api->JSON_TO_ARRAY($documento);
            $cantidad = $respuesta['MAX_AUTOR'] - 1; 

        } catch (\Throwable $th) {
            //throw $th;
            return "No disponible en este momento";
        }
        

        
        try {
            $json =  "{\n   \"rutEmpresa\" : \"$usuario->rut_empresa\",\n   \"tipoDTE\": \"$tipo\",\n   \"cantidadDctos\": \"$cantidad\"\n}\n";
            $api = new AbstrahereApi($usuario->rut_empresa,$usuario->rut_usuario);
            $documento = $api->POST("/cafsii",$json);
            $respuesta = $api->JSON_TO_ARRAY($documento);

        } catch (\Throwable $th) {
            return "No pudo completar carga de folios";
        }
        
        $tipo_docs_afectos = array("33","61","56","46");

        $desde = $respuesta['FOLIO_INI'];
		$hasta = $respuesta['FOLIO_FIN'];
        $fecha = $respuesta['FECHA'];
        $listado_tipos[$tipo] = $folioDisponible;
        $timbraje = date ( 'Y-m-d' , strtotime($fecha) );
        $fecha_vencimiento = $fecha;
        $fecha_vencimiento = '';
        if(in_array($tipo, $tipo_docs_afectos)){
            $timbraje = date ( 'Y-m-d' , strtotime($fecha) );
            //$fecha_vencimiento = strtotime ( '+180 day' , strtotime ( $fecha ) );
            $fecha_vencimiento = date("Y-m-d",strtotime('+180 day' , strtotime ( $timbraje )));
            //$fecha_vencimiento = date("Y-m-d",strtotime($fecha."+ 6 month"));
        }

        $ingreso = DB::table('caf')
        ->insert([
            'RUT_EMPRESA' => $this->rut_empresa,
            'CODIGO_DOC' => $tipo,
            'TIMBRAJE' => $fecha,
            'DESDE' => $desde,
            'HASTA' => $hasta,
            'FECHA_VENCIMIENTO' => $fecha_vencimiento,
            'rut_usuario' => $usuario->rut_usuario
        ]);

        $fecha = date("Y-m-d");
        $hora = date("H:i:s");

        $ingreso = DB::table('movimientos')
        ->insert([
            'fecha' => $fecha,
            'hora' => $hora,
            'movimiento' => 'CAF',
            'id_empresa' => $usuario->rut_empresa,
            'rut_trabajador' => $usuario->rut_usuario, 
        ]);


        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            json_encode(utf8_encode_recursivo((array)$request->all())),
            $respuesta,
            ENV('AMBIENTE_SII'),
            $request->ip()
        );


        
        return $response;




    }

}
