<?php

namespace App\Models;

use DB;
//use App\Models\Bodega;
use App\Models\Vendedor;
use App\Models\Cliente;
use App\Models\FormaPago;
use App\Models\AreaNegocio;
use App\Models\Producto;
use App\Traits\Foliable;
use App\Traits\Abstrahere;
use App\Api\AbstrahereApi;

class Cotizacion {
    use Foliable;
    use Abstrahere;

    const COTIZACION = 777;

    public function __construct(
            $id_empresa,
            $rut_empresa,
            $rut_usuario,
            $rut_receptor,
            $monto_neto,
            $monto_exento,
            $monto_no_facturable,
            $descuento,
            $tipo_documento,
            $folio,
            $area_negocio,
            $formaPago,
            $vendedor,
            $observacion,
            $direccion,
            array $detalles,
            array $adicionales
        )
    {
        $this->id_empresa = $id_empresa;
        $this->rut_empresa = $rut_empresa;
        $this->rut_usuario = $rut_usuario;
        $this->receptor = Cliente::obtenCliente(
            trim(strtoupper($rut_receptor)),
            $rut_empresa,
            $direccion
        );
        $this->emisor = $this->obtenDatosEmisor($rut_empresa);
        $this->monto_neto = $monto_neto;
        $this->monto_exento = $monto_exento;
        $this->monto_no_facturable = $monto_no_facturable;
        $this->descuento = $descuento;
        $this->tipo_documento = $tipo_documento;
        $this->folio = $folio;
        $this->area_negocio = $area_negocio;
        $this->formaPago = $formaPago;
        $this->vendedor = $vendedor;
        $this->observacion = $observacion;
        $this->detalles = $detalles;
        $this->totalDetalle = 0;
        $this->adicionales = $adicionales;

        $this->montos_totales = $this->calculaTotalesFactura(
            $this->tipo_documento,
            $this->monto_neto,
            $this->monto_exento,
            $this->descuento
        );

    }

    protected function fallo($mensaje, $rollback = true, $registra_folio = true)
    {
        if($registra_folio){
            $this->registraFolioSinOcupar($this->rut_empresa, $this->tipo_documento, $this->folio);
        }
        if($rollback){
            $this->rollback();
        }
        return ['mensaje' => $mensaje];
    }

    public function ingresarCotizacion()
    {

        if(is_null($this->receptor)) {
            return $this->fallo('Receptor invalido.', false, false);
        }


        $vendedor = Vendedor::obtenVendedor($this->vendedor, $this->rut_empresa);
        if(is_null($vendedor)) {
            return $this->fallo('# '.$this->vendedor.' - Vendedor invalido.', false, false);
        }

        $formaPago = FormaPago::obtenFormaPago($this->formaPago, $this->rut_empresa);
        if(is_null($formaPago)) {
            return $this->fallo('# '.$this->formaPago.' - Forma de pago invalida.', false, false);
        }

        $areaNegocio = AreaNegocio::obtenAreaNegocio($this->area_negocio, $this->rut_empresa);
        if(is_null($areaNegocio)) {
            return $this->fallo('# '.$this->area_negocio.' Area de Negocio invalida.', false, false);
        }

        if (empty($this->folio)) {
            do {

                $this->folio = $this->obtenFolio(
                    $this->rut_empresa,
                    $this->tipo_documento
                );

                $existe_folio = $this->existeFolio($this->rut_empresa, $this->tipo_documento, $this->folio);

            } while ($existe_folio);

        }else{
            $existe_folio = $this->existeFolio($this->rut_empresa, $this->tipo_documento, $this->folio);
            if($existe_folio) {
                return $this->fallo('Ya existe folio '.$this->folio.' tipo: '.$this->tipo_documento.'.', false, true);
            }

        }

        /*if(is_null($this->folio)) {
            return $this->fallo('No se pudo obtener folio.', false, true);
        }*/


        /*
        *Adicionales
        */
        $this->adicionales['Uno'] = $formaPago->NOMBRE_CPAGO;
        $this->adicionales['Siete'] = isset($this->observacion) ? $this->observacion : '';
        $this->adicionales['Treintayuno'] = $this->receptor->TELEFONO_CLIENTEPROVEEDOR;
        $this->adicionales['Treintaydos'] = $this->receptor->FAX_CLIENTEPROVEEDOR;
        $this->adicionales['Treintaytres'] = $this->monto_no_facturable;


        $datos_xml = [
            'TipoDTE' => $this->tipo_documento,
            'Folio' => $this->folio,
            'RUTEmisor' => trim(strtoupper($this->rut_empresa)),
            'RznSoc' => $this->emisor->razon,
			'GiroEmis' => $this->emisor->giro1,
			'Telefono' => $this->emisor->telefono,
			'Acteco' => $this->emisor->codigo1,
			'DirOrigen' => $this->emisor->direccion,
			'CmnaOrigen' => $this->emisor->comuna,
			'CiudadOrigen' => $this->emisor->ciudad,

            'RUTRecep' => trim(strtoupper($this->receptor->RUT_CLIENTEPROVEEDOR)),
            'RznSocRecep' => $this->receptor->RZ_CLIENTEPROVEEDOR,
            'GiroRecep' => $this->receptor->GIRO_CLIENTEPROVEEDOR,
            'DirRecep' => $this->receptor->DIRECCION_DIRECCION,
            'CmnaRecep' => $this->receptor->ID_COMUNA,
            'CiudadRecep' => $this->receptor->ID_CIUDAD,



            'neto' => round(($this->montos_totales['neto']), 0, PHP_ROUND_HALF_UP),
            'tasaIVA' => round((19), 0, PHP_ROUND_HALF_UP),
            'iva' => round(($this->montos_totales['iva']), 0, PHP_ROUND_HALF_UP),
            'total' => round(($this->montos_totales['total']), 0, PHP_ROUND_HALF_UP),
            'exento' => round(($this->montos_totales['exento']), 0, PHP_ROUND_HALF_UP),
            'NO_facturable' => round(($this->monto_no_facturable), 0, PHP_ROUND_HALF_UP),
            'MntTotal' => round(($this->montos_totales['total']), 0, PHP_ROUND_HALF_UP),
            'Detalles' => [],
        ];


        $id_ingreso_lv = $this->ingresoLibroVentas($formaPago);
        if(!$id_ingreso_lv){
            return $this->fallo('Excepción al ingresar datos libro ventas.');
        }

        if ($this->descuento > 0) {
            if(!$this->ingresoDescGlobal()){
                return $this->fallo('No se pudo realizar ingreso en descuento global.');
            }
        }

        if(!$this->ingresoAdicionalLibroVentas()){
            return $this->fallo('Excepción al ingresar datos en adicional libro ventas.');
        }

        if(!$this->ingresoDirLibroVenta()){
            return $this->fallo('No se pudo realizar ingreso en direccion libro de ventas.');
        }








        $totalDetalle = $totalDetalleExento = 0;
        foreach($this->detalles as $detalle){

            $producto = Producto::obtenProducto($detalle['Codigo'], $this->rut_empresa);
            if(is_null($producto)){
                return $this->fallo('Producto '.$detalle['Codigo'].' invalido.');
            }

            if( $producto->ESTADO_PRODUCTO != 1 ){
                return $this->fallo('Producto '.$detalle['Codigo'].' Se encuentra desactivado.');
            }

            $detalle['Precio'] = !isset($detalle['Precio']) ? $producto->VALOR_PRODUCTO : $detalle['Precio'];

            if($detalle['Afecto']){
                $exento = 0;
                $neto = round(($detalle['Precio']), 0, PHP_ROUND_HALF_UP);
                $total = round(($detalle['Cantidad'] * $neto - $detalle['Descuento']), 0, PHP_ROUND_HALF_UP);
                $id_usuario = '';

                $totalDetalle += $detalle['Cantidad'] * $neto;

            } else {
                $exento = round(($detalle['Precio']), 0, PHP_ROUND_HALF_UP);
                $neto = 0;
                $total = round((($detalle['Cantidad'] * $exento) - $detalle['Descuento']), 0, PHP_ROUND_HALF_UP);
                $id_usuairo = 'x';

                $totalDetalleExento += $detalle['Cantidad'] * $exento;

            }

            $datos_xml['Detalles'][] = [
                'VlrCodigo' => $producto->CODIGO_PRODUCTO,
                'NmbItem' => $producto->DESCRIPCION_PRODUCTO,
                'QtyItem' => $detalle['Cantidad'],
                'UnmdItem' => $producto->NOMBRE,
                'PrcItem' => $detalle['Precio'],
                'MontoItem' => $total,
            ];

            if(!$this->ingresaDetalleDoc2($detalle, $producto, $exento, $neto, $total, $id_usuario)){
                return $this->fallo('No se pudo realizar el ingreso de detalle.');
            }

            /*if(!$this->ingresoDetalleInvProductos($producto, $detalle, $bodega)){
                return $this->fallo('No se pudo realizar el ingreso de detalle de inventario.');
            }*/



        }


        if($totalDetalle != $this->monto_neto){
            return $this->fallo('MontoNeto no coincide con sumatoria de detalles, valor debería ser: '.$totalDetalle.'.');
        }
        if($totalDetalleExento != $this->monto_exento){
            return $this->fallo('MontoExento no coincide con sumatoria de detalles, valor debería ser: '.$totalDetalleExento.'.');
        }

        $abstrahere = new AbstrahereApi($this->rut_empresa, $this->rut_usuario);
        
        $adicional_xml = $this->generaXmlAdicionalesApi($this->adicionales);
        $datapost = $this->generaXmlCotizacion($datos_xml,$adicional_xml);
        
        $xml = json_decode($abstrahere->POST("/xmls", $datapost));

        if(empty($xml->folio)){
            return $this->fallo('Error al generar documento, tipo:'.$this->tipo_documento.' folio: '.$this->folio);
        }

        return [
            'mensaje' => 'Documento generado con exito.',
            'tipo' =>  $xml->tipoDTE,
            'folio' =>  $xml->folio
        ];
    }

    protected function ingresoLibroVentas($formaPago)
    {
        try{
        $id_ingreso_lv = DB::table('libro_ventas')
            ->insertGetId([
                'rut' => $this->rut_empresa,
                'mes' => date('m', time()),
                'fecha' => date('Y-m-d', time()),
                'typo_doc' => $this->tipo_documento,
                'n_doc' => $this->folio,
                'rut_c' => strtoupper($this->receptor->RUT_CLIENTEPROVEEDOR),
                'nombre_c' => $this->receptor->RZ_CLIENTEPROVEEDOR,
                'EXENTO_LVENTA' => $this->formateaNumero($this->montos_totales['exento']),
                'DESCUENTO_LVENTA' => $this->formateaNumero($this->descuento),
                'ESPECIFICO_LVENTA' => 0,
                'valor_n' => $this->formateaNumero($this->montos_totales['neto']),
                'valor_i' => $this->formateaNumero($this->montos_totales['iva']),
                'IVARETENIDO_LVENTA' => 0,
                'valor_t' => $this->formateaNumero($this->montos_totales['total']),
                'ANO_LVENTA' => date('Y', time()),
                'CTACTE_LVENTA' => 1,
                'FPAGO_LVENTA' => $formaPago->DIAS_CPAGO,
                'ANEGOCIO_LVENTA' => $this->area_negocio,
                'SUCURSAL_LVENTA' => 'CASA MATRIZ',
                'OBS_LVENTA' => $this->observacion,
                'DISPONIBLE1_LVENTA' => $formaPago->NOMBRE_CPAGO,
                'DISPONIBLE2_LVENTA' => $this->adicionales['Dos'],
                'DISPONIBLE3_LVENTA' => '',
                'DISPONIBLE4_LVENTA' => '',
                'DISPONIBLE5_LVENTA' => '',
                'DISPONIBLE6_LVENTA' => date('Y-m-d', strtotime('+'.$formaPago->DIAS_CPAGO.' day', time())),
                'FINGRESO_LVENTAS' => date('Y-m-d'),
                'UINGRESO_LVENTAS' => $this->rut_usuario,
                'ID_ENVIO' => 1,
                'datos_empresa_id' => $this->id_empresa,
            ]);
        }catch (Exception $e) {
            return false;
        }

        return $id_ingreso_lv;
    }

    protected function ingresoAdicionalLibroVentas()
    {
        try{
            $ingreso = DB::table('adicional_libro_ventas')
            ->insert([
                'RUT_EMPRESA' => $this->rut_empresa,
                'RUT_CLIENTE' => strtoupper($this->receptor->RUT_CLIENTEPROVEEDOR),
                'typo_doc' => $this->tipo_documento,
                'n_doc' => $this->folio,
                'N_ORDEN' => '',
                'N_COTIZACION' => '',
                'GUIA_DESPACHO' => '',
                'fecha_entrega_cot' => '',
                'ESTADO_NV' => 1,
                'CONTACTO' => '',
                'RUT_EXTRANJERO' => '-',
                'MONTO_NO_FACTURABLE' => $this->monto_no_facturable,
            ]);
        }catch (Exception $e) {
            return false;
        }

        return $ingreso;
    }



    protected function ingresoDescGlobal()
    {
        try{
            $ingreso = DB::table('desc_global')
                ->insert([
                    'ID_EMPRESA' => $this->rut_empresa,
                    'FOLIO_DOC' => $this->folio,
                    'TIPO_DOC' => $this->tipo_documento,
                    'TIPO_DESC' => 2,
                    'VALOR_DESC' => $this->formateaNumero($this->descuento),
                    'ADICIONAL1' => '',
                    'ADICIONAL2' => '',
                    'ADICIONAL3' => '',
                ]);
        } catch (Exception $e){
            return false;
        }


        return $ingreso;
    }

    protected function ingresoDirLibroVenta()
    {
        try{
            $ingreso = DB::table('dir_libro_venta')
                ->insert([
                    'ID_EMPRESA' => $this->rut_empresa,
                    'FOLIO_DIR_LVENTA' => $this->folio,
                    'TIPO_DIR_LVENTA' => $this->tipo_documento,
                    'ID_DIRECCION' => $this->receptor->ID_DIRECCION,
                    'ADICIONAL_DIR_LVENTA' => '',
                ]);
        } catch (Exception $e){
            return false;
        }

        return $ingreso;
    }




    protected function ingresaDetalleDoc2($detalle, $producto, $exento, $neto, $total, $id_usuario)
    {
        try{
            $ingreso = DB::table('detalle_doc2')
                ->insert([
                    'RUT_EMPRESA' => $this->rut_empresa,
                    'RUT_CLIENTE' => $this->receptor->RUT_CLIENTEPROVEEDOR,
                    'ID_CORRE_DETALLEDOC' => $this->folio,
                    'ID_TIPODOC' => $this->tipo_documento,
                    'CPROD_DETALLEDOC' => $producto->CODIGO_PRODUCTO,
                    'DETALLE_DETALLEDOC' => $producto->DESCRIPCION_PRODUCTO,
                    'ESPECIFICO_DETALLEDOC' => '',
                    'EXENTO_DETALLEDOC' => $exento,
                    'NETO_DETALLEDOC' => $neto,
                    'CANTIDAD_DETALLEDOC' => $detalle['Cantidad'],
                    'TIPODESC__DETALLEDOC' => 1,
                    'VADESC__DETALLEDOC' => $detalle['Descuento'],
                    'DESC__DETALLEDOC' => $detalle['Descuento'],
                    'TOTAL_DETALLEDOC' => $total,
                    'ID_USUARIO' => $id_usuario,
                    'FECHA_DETALLEDOC' => date('Y-m-d', time()),
                    'ESTADO_DETALLEDOC' => 2,
                    'datos_empresa_id' => $this->id_empresa,
                ]);
        } catch(Exception $e) {
            return false;
        }

        return $ingreso;
    }

    protected function ingresaReferencia($referencia, $tipo_doc, $folio_doc)
    {
        try{
            $ingreso = DB::table('ref_sistema_ge_especial')
                ->insert([
                    'RUT_EMPRESA' => $this->rut_empresa,
                    'TIPO_DOC' => $referencia['TipoRef'],
                    'NDOC' => $referencia['FolioRef'],
                    'FECHA_DOC' => $referencia['FechaRef'],
                    'RAZON_DOC' => $referencia['RazonRef'],
                    'ADICIONAL1' => $folio_doc,
                    'ADICIONAL2' => $tipo_doc,
                    'ADICIONAL6' => 1,

                ]);
        } catch(Exception $e){
            return false;
        }

        return $ingreso;
    }

    protected function ingresaDetalleLargo($detalle_largo, $tipo_doc, $folio_doc)
    {
        try{
            $ingreso = DB::table('detalle_doc2_largo_dte')
                ->insert([
                    'FOLIO' => $folio_doc,
                    'TIPO_DOC' => $tipo_doc,
                    'DETALLE_LARGO' => '',
                    'RUT_EMPRESA' => $this->rut_empresa,
                    'ITEM' => ''
                ]);
        } catch(Exception $e){
            return false;
        }

        return $ingreso;
    }


    protected function calculaTotalesFactura($tipoDocumento, $montoNeto, $montoExento, $descuento)
    {
        $montosTotales = [];


        $montosTotales['neto'] = $montoNeto - $descuento;
        $montosTotales['exento'] = $montoExento;
        $montosTotales['iva'] = ($montoNeto - $descuento) * env('IVA');
        $montosTotales['total'] = ($montoNeto - $descuento) + $montoExento + $montosTotales['iva'];


        return $montosTotales;
    }

    protected function obtenDatosEmisor($rut_emisor)
   {
       return DB::table('datos_empresa')
           ->whereRaw('rut = \''.$rut_emisor.'\'')
           ->where('ESISTEMA', '=', 1)
           ->first();
   }
    protected function rollback(){
        $ingreso = DB::table('libro_ventas')
            ->whereRaw('rut = \''.$this->rut_empresa.'\'')
            ->where('typo_doc', '=', $this->tipo_documento)
            ->where('n_doc', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('ctacte')
            ->whereRaw('rut_empresa = \''.$this->rut_empresa.'\'')
            ->where('tipo_doc', '=', $this->tipo_documento)
            ->where('n_doc_ctacte', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('desc_global')
            ->whereRaw('ID_EMPRESA = \''.$this->rut_empresa.'\'')
            ->where('TIPO_DOC', '=', $this->tipo_documento)
            ->where('FOLIO_DOC', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('dir_libro_venta')
            ->whereRaw('ID_EMPRESA = \''.$this->rut_empresa.'\'')
            ->where('TIPO_DIR_LVENTA', '=', $this->tipo_documento)
            ->where('FOLIO_DIR_LVENTA', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('adicional_libro_ventas')
            ->whereRaw('RUT_EMPRESA = \''.$this->rut_empresa.'\'')
            ->where('typo_doc', '=', $this->tipo_documento)
            ->where('n_doc', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('detalle_doc2')
            ->whereRaw('RUT_EMPRESA = \''.$this->rut_empresa.'\'')
            ->where('ID_TIPODOC', '=', $this->tipo_documento)
            ->where('ID_CORRE_DETALLEDOC', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('detalle_inv_productos')
            ->whereRaw('RUT_EMPRESA = \''.$this->rut_empresa.'\'')
            ->where('FOLIO_DOC', '=', $this->tipo_documento)
            ->where('N_DOC', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('ref_sistema_ge_especial')
            ->whereRaw('RUT_EMPRESA = \''.$this->rut_empresa.'\'')
            ->where('ADICIONAL2', '=', $this->tipo_documento)
            ->where('ADICIONAL1', '=', $this->folio)
            ->delete();
    }

    protected function generaXmlCotizacion($datos,$adicionales)
    {
        $xml_detalle = '';

        $item = 1;
        foreach($datos['Detalles'] as $detalle) {
            $xml_detalle .= '<Detalle>
               <NroLinDet>'.$item.'</NroLinDet>
               <CdgItem>
                  <TpoCodigo />
                  <VlrCodigo>'.$detalle['VlrCodigo'].'</VlrCodigo>
               </CdgItem>
               <NmbItem>'.$detalle['NmbItem'].'</NmbItem>
               <QtyItem>'.$detalle['QtyItem'].'</QtyItem>
               <UnmdItem>'.$detalle['UnmdItem'].'</UnmdItem>
               <PrcItem>'.$detalle['PrcItem'].'</PrcItem>
               <MontoItem>'.$detalle['MontoItem'].'</MontoItem>
            </Detalle>'.PHP_EOL;
            $item++;
        }

        $xml_no_facturable = '';
        if (!empty($datos['NO_facturable'])) {
            $valor_total_monto_no_facturable = number_format(($datos['MntTotal'] + $datos['NO_facturable']),0,',','');

            $xml_no_facturable = '<MontoNF>'.$datos['NO_facturable'].'</MontoNF>
                    <TotalPeriodo>'.$valor_total_monto_no_facturable.'</TotalPeriodo>';
            //$xml_no_facturable .= '<MontoPeriodo>'.$valor_total_monto_no_facturable.'</MontoPeriodo>';
        }

        $xml = '
            <Body>
                <DTE>
                    <Documento>
                    <Encabezado>
                        <IdDoc>
                            <TipoDTE>'.$datos['TipoDTE'].'</TipoDTE>
                            <Folio>'.$datos['Folio'].'</Folio>
                            <FchEmis>'.date('Y-m-d', time()).'</FchEmis>
                            <IndServicio>3</IndServicio>
                        </IdDoc>
                        <Emisor>
                            <RUTEmisor>'.$datos['RUTEmisor'].'</RUTEmisor>
                            <RznSoc>'.$datos['RznSoc'].'</RznSoc>
                            <GiroEmis>'.$datos['GiroEmis'].'</GiroEmis>
                            <Telefono>'.$datos['Telefono'].'</Telefono>
                            <Acteco>'.$datos['Acteco'].'</Acteco>
                            <DirOrigen>'.$datos['DirOrigen'].'</DirOrigen>
                            <CmnaOrigen>'.$datos['CmnaOrigen'].'</CmnaOrigen>
                            <CiudadOrigen>'.$datos['CiudadOrigen'].'</CiudadOrigen>
                        </Emisor>
                        <Receptor>
                            <RUTRecep>'.$datos['RUTRecep'].'</RUTRecep>
                            <RznSocRecep>'.$datos['RznSocRecep'].'</RznSocRecep>
                            <GiroRecep>'.$datos['GiroRecep'].'</GiroRecep>
                            <DirRecep>'.$datos['DirRecep'].'</DirRecep>
                            <CmnaRecep>'.$datos['CmnaRecep'].'</CmnaRecep>
                            <CiudadRecep>'.$datos['CiudadRecep'].'</CiudadRecep>
                        </Receptor>
                        <Totales>
                            <MntNeto>'.$datos['neto'].'</MntNeto>
                            <MntExe>'.$datos['exento'].'</MntExe>
                            <TasaIVA>'.$datos['tasaIVA'].'</TasaIVA>
                            <IVA>'.$datos['iva'].'</IVA>
                            <MntTotal>'.$datos['MntTotal'].'</MntTotal>
                            '.$xml_no_facturable.'
                        </Totales>
                    </Encabezado>
                    '.$xml_detalle.'

                    </Documento>

                    <Adicionales>
                        '.$adicionales.'
                    </Adicionales>
                </DTE>
                <idImpreso></idImpreso>
            </Body>
            ';

            

         return $xml;


    }

    protected function generaXmlAdicionalesApi($datos)
    {
        $xml = '<Uno>'.(isset($datos['Uno']) ? $datos['Uno'] : '').'</Uno>
    	       <Dos>'.(isset($datos['Dos']) ? $datos['Dos'] : '').'</Dos>
               <Tres>'.(isset($datos['Tres']) ? $datos['Tres'] : '').'</Tres>
               <Cuatro>'.(isset($datos['Cuatro']) ? $datos['Cuatro'] : '').'</Cuatro>
               <Cinco>'.(isset($datos['Cinco']) ? $datos['Cinco'] : '').'</Cinco>
               <Seis>'.(isset($datos['Seis']) ? $datos['Seis'] : '').'</Seis>
               <Siete>'.(isset($datos['Siete']) ? $datos['Siete'] : '').'</Siete>
               <Ocho>'.(isset($datos['Ocho']) ? $datos['Ocho'] : '').'</Ocho>
               <Nueve>'.(isset($datos['Nueve']) ? $datos['Nueve'] : '').'</Nueve>
               <Diez>'.(isset($datos['Diez']) ? $datos['Diez'] : '').'</Diez>
               <Once>'.(isset($datos['Once']) ? $datos['Once'] : '').'</Once>
               <Doce>'.(isset($datos['Doce']) ? $datos['Doce'] : '').'</Doce>
               <Trece>'.(isset($datos['Trece']) ? $datos['Trece'] : '').'</Trece>
               <Catorce>'.(isset($datos['Catorce']) ? $datos['Catorce'] : '').'</Catorce>
               <Quince>'.(isset($datos['Quince']) ? $datos['Quince'] : '').'</Quince>
               <Dieciseis>'.(isset($datos['Dieciseis']) ? $datos['Dieciseis'] : '').'</Dieciseis>
               <Diecisiete>'.(isset($datos['Diecisiete']) ? $datos['Diecisiete'] : '').'</Diecisiete>
               <Dieciocho>'.(isset($datos['Dieciocho']) ? $datos['Dieciocho'] : '').'</Dieciocho>
               <Diecinueve>'.(isset($datos['Diecinueve']) ? $datos['Diecinueve'] : '').'</Diecinueve>
               <Veinte>'.(isset($datos['Veinte']) ? $datos['Veinte'] : '').'</Veinte>
               <Veintiuno>'.(isset($datos['Veintiuno']) ? $datos['Veintiuno'] : '').'</Veintiuno>
               <Veintidos>'.(isset($datos['Veintidos']) ? $datos['Veintidos'] : '').'</Veintidos>
               <Veintitres>'.(isset($datos['Veintitres']) ? $datos['Veintitres'] : '').'</Veintitres>
               <Veinticuatro>'.(isset($datos['Veinticuatro']) ? $datos['Veinticuatro'] : '').'</Veinticuatro>
               <Veinticinco>'.(isset($datos['Veinticinco']) ? $datos['Veinticinco'] : '').'</Veinticinco>
               <Veintiseis>'.(isset($datos['Veintiseis']) ? $datos['Veintiseis'] : '').'</Veintiseis>
               <Veintisiete>'.(isset($datos['Veintisiete']) ? $datos['Veintisiete'] : '').'</Veintisiete>
               <Veintiocho>'.(isset($datos['Veintiocho']) ? $datos['Veintiocho'] : '').'</Veintiocho>
               <Veintinueve>'.(isset($datos['Veintinueve']) ? $datos['Veintinueve'] : '').'</Veintinueve>
               <Treinta>'.(isset($datos['Treinta']) ? $datos['Treinta'] : '').'</Treinta>
               <Treintayuno>'.(isset($datos['Treintayuno']) ? $datos['Treintayuno'] : '').'</Treintayuno>
               <Treintaydos>'.(isset($datos['Treintaydos']) ? $datos['Treintaydos'] : '').'</Treintaydos>
               <Treintaytres>'.(isset($datos['Treintaytres']) ? $datos['Treintaytres'] : '').'</Treintaytres>
               <Treintaycuatro>'.(isset($datos['Treintaycuatro']) ? $datos['Treintaycuatro'] : '').'</Treintaycuatro>
               <Treintaycinco>'.(isset($datos['Treintaycinco']) ? $datos['Treintaycinco'] : '').'</Treintaycinco>
               <Treintayseis>'.(isset($datos['Treintayseis']) ? $datos['Treintayseis'] : '').'</Treintayseis>
               <Treintaysiete>'.(isset($datos['Treintaysiete']) ? $datos['Treintaysiete'] : '').'</Treintaysiete>
               <Treintayocho>'.(isset($datos['Treintayocho']) ? $datos['Treintayocho'] : '').'</Treintayocho>
               <Treintaynueve>'.(isset($datos['Treintaynueve']) ? $datos['Treintaynueve'] : '').'</Treintaynueve>
               <Cuarenta>'.(isset($datos['Cuarenta']) ? $datos['Cuarenta'] : '').'</Cuarenta>
               <Cuarentayuno>'.(isset($datos['Cuarentayuno']) ? $datos['Cuarentayuno'] : '').'</Cuarentayuno>
               <Cuarentaydos>'.(isset($datos['Cuarentaydos']) ? $datos['Cuarentaydos'] : '').'</Cuarentaydos>
               <Cuarentaytres>'.(isset($datos['Cuarentaytres']) ? $datos['Cuarentaytres'] : '').'</Cuarentaytres>
               <Cuarentaycuatro>'.(isset($datos['Cuarentaycuatro']) ? $datos['Cuarentaycuatro'] : '').'</Cuarentaycuatro>
               <Cuarentaycinco>'.(isset($datos['Cuarentaycinco']) ? $datos['Cuarentaycinco'] : '').'</Cuarentaycinco>
               <Cuarentayseis>'.(isset($datos['Cuarentayseis']) ? $datos['Cuarentayseis'] : '').'</Cuarentayseis>
               <Cuarentaysiete>'.(isset($datos['Cuarentaysiete']) ? $datos['Cuarentaysiete'] : '').'</Cuarentaysiete>
               <Cuarentayocho>'.(isset($datos['Cuarentayocho']) ? $datos['Cuarentayocho'] : '').'</Cuarentayocho>
               <Cuarentaynueve>'.(isset($datos['Cuarentaynueve']) ? $datos['Cuarentaynueve'] : '').'</Cuarentaynueve>
               <Cincuenta>'.(isset($datos['Cincuenta']) ? $datos['Cincuenta'] : '').'</Cincuenta>';

       return $xml;
    }

    protected function formateaNumero($numero)
    {
        return number_format($numero, 0, ',', '');
    }
}
