<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\Autenticable;
use DB;
use Logger;
use Pheanstalk\Pheanstalk;

class MailController extends Controller
{
    use Autenticable;

    public function evioMailDocumento(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }


        $this->validateJson($request, [
            'rut_empresa' => 'required|rut',
            'tipo' => 'required',
            'folio' => 'required',
            'nombre_contacto' => 'required',
            'email_contacto' => 'required'
        ]);

        $respuestas = [];

        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            $datos,
            $respuestas,
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        //validar que exista el documento en la base de datos
        $documento = DB::table('libro_ventas')
            ->select('ID_LV as id')
            ->whereRaw('rut = \''.$usuario->rut_empresa.'\'')
            ->where('typo_doc', '=', $datos['tipo'])
            ->where('n_doc', '=', $datos['folio'])
            ->get();


        if(empty($documento)) {
            $respuestas[] = ['mensaje' => 'Documento tipo: '.$datos['tipo'].' folio: '.$datos['folio'].' NO existe en sistema.'];

            return response()->json($respuestas);
        }


        $conf_api = DB::table('tbl_config_cobranza')
            ->select('api as api')
            ->whereRaw('ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->get();

        if(empty($conf_api[0]->api)){
            $respuestas[] = ['mensaje' => 'Debe configurar mail de salida en sistema ERP.'];

            return response()->json($respuestas);
        }


        //agendar tarea para envio beanstalk
        $pheanstalk = Pheanstalk::create('127.0.0.1');

        // Queue a Job
        $pheanstalk
          ->useTube('EnviaMail')
          ->put( json_encode( [
              'rut_empresa' => $usuario->rut_empresa,
              'tipo' => $datos['tipo'],
              'folio' => $datos['folio'],
              'nombre_contacto' => $datos['nombre_contacto'],
              'email_contacto' => $datos['email_contacto']
            ] ) );

        $respuestas[] = ['mensaje' => 'Documento en estado de envio.'];

        return response()->json($respuestas);
    }
}
