<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\Autenticable;
use DB;

class FormaPagoController extends Controller
{
    use Autenticable;

    public function index(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $formaPago = DB::table('cpago')
            ->select('ID_CPAGO as id', 'NOMBRE_CPAGO as nombre')
            ->whereRaw('ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->get();

        return response()->json($formaPago);
    }

    public function getFormasPagoPos(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $formaPago = DB::table('flujo_pago')
            ->select('id as id', 'nombre as nombre','descripcion','DTE as dte')
            ->get();

        return response()->json($formaPago);
    }
}
