<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\Autenticable;
use DB;

class DatoWebController extends Controller
{
    use Autenticable;

    public function generales(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $datos_generales = DB::table('datos_generales')
            ->select('id as id', 'titulo as titulo', 'descripcion', 'imagen', 'color_corporativo', 'color_secundario', 'color_alternativo')
            ->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
            ->get();

        $datos_generales[0]->imagen = "http://softnet.cl/sistems/contabilidad/catalogo/woopy/".$usuario->rut_empresa."/".$datos_generales[0]->imagen;

        return response()->json($datos_generales);
    }

    public function redes_sociales(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $datos = DB::table('datos_sociales')
            ->select('id as id', 'facebook', 'instagram', 'twitter', 'linkedin')
            ->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
            ->get();


        return response()->json($datos);
    }
    public function conctacto(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $datos = DB::table('contacto_web')
            ->select('id as id', 'titulo', 'subtitulo')
            ->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
            ->get();

        return response()->json($datos);
    }
    public function sucursales(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $datos = DB::table('sucursales')
            ->select('ID_SUCURSAL as id','NOMBRE_SUCURSAL as nombre', 'DIRECCION_SUCURSAL as direccion','ID_COMUNA as comuna','ID_CIUDAD as ciudad')
            ->whereRaw('ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->get();

        return response()->json($datos);
    }
    public function enunciado_principal(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }
        $datos = DB::table('enunciado_principal')
            ->select('id as id', 'titulo', 'subtitulo','descripcion','imagen')
            ->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
            ->get();

        $datos[0]->imagen = "http://softnet.cl/sistems/contabilidad/catalogo/woopy/".$usuario->rut_empresa."/".$datos[0]->imagen;

        return response()->json($datos);
    }
    public function paginas(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }
        $lista = array();
        $listaPaginas = array();

        $datos = DB::table('paginas_web')
            ->select('id as id', 'titulo', 'subtitulo','descripcion')
            ->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
            ->get();


        foreach ($datos as $key => $d) {
            // code...

            $datos_seccion = DB::table('seccion_web')
                ->select('id as id', 'titulo', 'subtitulo','descripcion','estado','imagen')
                ->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
                ->whereRaw('pagina_web_id = \''.$d->id.'\'')
                ->get();

            //indicar url de imagen
            foreach ($datos_seccion as $key_seccion => $seccion) {
                // code...
                $datos_seccion[$key_seccion]->imagen = "http://softnet.cl/sistems/contabilidad/catalogo/woopy/".$usuario->rut_empresa."/".$datos_seccion[$key_seccion]->imagen;
            }


            $lista = [
                'id' => $d->id,
                'titulo' => $d->titulo,
                'subtitulo' => $d->subtitulo,
                'descripcion' => $d->descripcion,
                'seccion' => $datos_seccion
            ];
            array_push($listaPaginas, $lista);

        }


        return response()->json($listaPaginas);
    }

    public function noticias(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }
        $datos = DB::table('noticias')
            ->select('id as id', 'titulo', 'subtitulo','descripcion','imagen')
            ->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
            ->get();

        foreach ($datos as $key => $d) {
            // code...
            $datos[$key]->imagen = "http://softnet.cl/sistems/contabilidad/catalogo/woopy/".$usuario->rut_empresa."/".$datos[$key]->imagen;
        }

        return response()->json($datos);
    }

}
