<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\Autenticable;
use DB;

class CampanaController extends Controller
{
    use Autenticable;

    public function index(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $bodegas = DB::table('campana_web')
            ->select('id_campana as id', 'nombre as nombre', 'descripcion as descripcion','fecha_inicio as fecha_inicio','fecha_termino as fecha_termino', 'estado as estado')
            ->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
            ->get();

        return response()->json($bodegas);
    }


}
